/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.internal;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.zaxxer.nuprocess.NuProcess;
import com.zaxxer.nuprocess.NuProcessHandler;
import com.zaxxer.nuprocess.internal.Constants;
import com.zaxxer.nuprocess.internal.IEventProcessor;
import com.zaxxer.nuprocess.internal.LibC;
import com.zaxxer.nuprocess.internal.ReferenceCountedFileDescriptor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BasePosixProcess
implements NuProcess {
    protected static final Logger LOGGER = Logger.getLogger(BasePosixProcess.class.getCanonicalName());
    private static final boolean IS_SOFTEXIT_DETECTION;
    private static final ByteBuffer STDIN_CLOSED_PENDING_WRITE_TOMBSTONE;
    protected static final IEventProcessor<? extends BasePosixProcess>[] processors;
    protected static int processorRoundRobin;
    private int exitcode;
    protected IEventProcessor<? super BasePosixProcess> myProcessor;
    protected volatile NuProcessHandler processHandler;
    protected volatile int pid;
    protected volatile boolean isRunning;
    public final AtomicBoolean cleanlyExitedBeforeProcess;
    protected AtomicInteger exitCode;
    protected CountDownLatch exitPending;
    protected AtomicBoolean userWantsWrite;
    private Memory outBufferMemory;
    private Memory errBufferMemory;
    private Memory inBufferMemory;
    protected ByteBuffer outBuffer;
    protected ByteBuffer errBuffer;
    protected ByteBuffer inBuffer;
    protected ReferenceCountedFileDescriptor stdin;
    protected ReferenceCountedFileDescriptor stdout;
    protected ReferenceCountedFileDescriptor stderr;
    protected volatile int stdinWidow;
    protected volatile int stdoutWidow;
    protected volatile int stderrWidow;
    protected AtomicBoolean stdinClosing;
    protected boolean outClosed;
    protected boolean errClosed;
    private ConcurrentLinkedQueue<ByteBuffer> pendingWrites;

    protected BasePosixProcess(NuProcessHandler processListener) {
        this.processHandler = processListener;
        this.userWantsWrite = new AtomicBoolean();
        this.cleanlyExitedBeforeProcess = new AtomicBoolean();
        this.exitCode = new AtomicInteger();
        this.exitPending = new CountDownLatch(1);
        this.stdin = new ReferenceCountedFileDescriptor(-1);
        this.stdout = new ReferenceCountedFileDescriptor(-1);
        this.stderr = new ReferenceCountedFileDescriptor(-1);
        this.stdinClosing = new AtomicBoolean();
        this.outClosed = true;
        this.errClosed = true;
    }

    public abstract NuProcess start(List<String> var1, String[] var2, Path var3);

    public abstract void run(List<String> var1, String[] var2, Path var3);

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public int waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        if (timeout == 0L) {
            this.exitPending.await();
        } else if (!this.exitPending.await(timeout, unit)) {
            return Integer.MIN_VALUE;
        }
        return this.exitCode.get();
    }

    @Override
    public void destroy(boolean force) {
        int result;
        if (this.isRunning && (result = LibC.kill(this.pid, force ? 9 : 15)) != 0) {
            int errno = Native.getLastError();
            if (errno == 3) {
                LOGGER.log(Level.FINE, "{0}: The process exited before it could be {1}", new Object[]{this.pid, force ? "killed" : "terminated"});
            } else {
                throw new RuntimeException("Sending signal failed, return code: " + result + ", last error: " + errno);
            }
        }
    }

    @Override
    public void wantWrite() {
        block4: {
            try {
                int fd = this.stdin.acquire();
                if (fd != -1) {
                    this.userWantsWrite.set(true);
                    this.myProcessor.queueWrite(this);
                    break block4;
                }
                throw new IllegalStateException("closeStdin() method has already been called.");
            }
            finally {
                this.stdin.release();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void closeStdin(boolean force) {
        if (force) {
            try {
                int fd = this.stdin.acquire();
                if (fd == -1) return;
                if (this.myProcessor != null) {
                    this.myProcessor.closeStdin(this);
                }
                this.stdin.close();
                return;
            }
            finally {
                this.stdin.release();
            }
        } else {
            if (!this.stdinClosing.compareAndSet(false, true)) throw new IllegalStateException("closeStdin() method has already been called.");
            this.pendingWrites.add(STDIN_CLOSED_PENDING_WRITE_TOMBSTONE);
            this.myProcessor.queueWrite(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStdin(ByteBuffer buffer) {
        block4: {
            try {
                int fd = this.stdin.acquire();
                boolean closing = this.stdinClosing.get();
                if (fd != -1 && !closing) {
                    this.pendingWrites.add(buffer);
                    this.myProcessor.queueWrite(this);
                    break block4;
                }
                throw new IllegalStateException("closeStdin() method has already been called.");
            }
            finally {
                this.stdin.release();
            }
        }
    }

    @Override
    public boolean hasPendingWrites() {
        return !this.pendingWrites.isEmpty();
    }

    @Override
    public void setProcessHandler(NuProcessHandler processHandler) {
        this.processHandler = processHandler;
    }

    public int getPid() {
        return this.pid;
    }

    @Override
    public int getPID() {
        return this.pid;
    }

    public ReferenceCountedFileDescriptor getStdin() {
        return this.stdin;
    }

    public ReferenceCountedFileDescriptor getStdout() {
        return this.stdout;
    }

    public ReferenceCountedFileDescriptor getStderr() {
        return this.stderr;
    }

    public boolean isSoftExit() {
        return IS_SOFTEXIT_DETECTION && this.outClosed && this.errClosed;
    }

    public void onExit(int statusCode) {
        if (this.exitPending.getCount() == 0L) {
            return;
        }
        try {
            this.closeStdin(true);
            this.stdout.close();
            this.stderr.close();
            this.isRunning = false;
            this.exitCode.set(statusCode);
            if (this.outBuffer != null && !this.outClosed) {
                this.outBuffer.flip();
                this.processHandler.onStdout(this.outBuffer, true);
            }
            if (this.errBuffer != null && !this.errClosed) {
                this.errBuffer.flip();
                this.processHandler.onStderr(this.errBuffer, true);
            }
            if (statusCode != 0x7FFFFFFE) {
                this.processHandler.onExit(statusCode);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception thrown from handler", e);
        }
        finally {
            this.exitPending.countDown();
            this.outBufferMemory = null;
            this.errBufferMemory = null;
            this.inBufferMemory = null;
            this.outBuffer = null;
            this.errBuffer = null;
            this.inBuffer = null;
            this.processHandler = null;
            Memory.purge();
        }
    }

    public void readStdout(int availability, int fd) {
        if (this.outClosed || availability == 0) {
            return;
        }
        try {
            if (availability < 0) {
                this.outClosed = true;
                this.outBuffer.flip();
                this.processHandler.onStdout(this.outBuffer, true);
                return;
            }
            int read = LibC.read(fd, this.outBuffer, Math.min(availability, this.outBuffer.remaining()));
            if (read == -1) {
                this.outClosed = true;
                int errno = Native.getLastError();
                throw new RuntimeException("Unexpected EOF reading stdout, errno: " + errno);
            }
            this.outBuffer.limit(this.outBuffer.position() + read);
            this.outBuffer.position(0);
            this.processHandler.onStdout(this.outBuffer, false);
            this.outBuffer.compact();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception thrown from handler", e);
        }
        if (!this.outBuffer.hasRemaining()) {
            throw new RuntimeException("stdout buffer has no bytes remaining");
        }
    }

    public void readStderr(int availability, int fd) {
        if (this.errClosed || availability == 0) {
            return;
        }
        try {
            if (availability < 0) {
                this.errClosed = true;
                this.errBuffer.flip();
                this.processHandler.onStderr(this.errBuffer, true);
                return;
            }
            int read = LibC.read(fd, this.errBuffer, Math.min(availability, this.errBuffer.remaining()));
            if (read == -1) {
                this.errClosed = true;
                int errno = Native.getLastError();
                throw new RuntimeException("Unexpected EOF reading stderr, errno: " + errno);
            }
            this.errBuffer.limit(this.errBuffer.position() + read);
            this.errBuffer.position(0);
            this.processHandler.onStderr(this.errBuffer, false);
            this.errBuffer.compact();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception thrown from handler", e);
        }
        if (!this.errBuffer.hasRemaining()) {
            throw new RuntimeException("stderr buffer has no bytes remaining");
        }
    }

    public boolean writeStdin(int availability, int fd) {
        if (availability <= 0 || fd == -1) {
            return false;
        }
        if (this.inBuffer.hasRemaining()) {
            int wrote;
            do {
                if ((wrote = LibC.write(fd, this.inBuffer, Math.min(availability, this.inBuffer.remaining()))) >= 0) continue;
                int errno = Native.getLastError();
                if (errno == 11 || errno == 35) {
                    availability /= 4;
                    continue;
                }
                this.stdin.close();
                return false;
            } while (wrote < 0);
            availability -= wrote;
            this.inBuffer.position(this.inBuffer.position() + wrote);
            if (this.inBuffer.hasRemaining()) {
                return true;
            }
        }
        if (!this.pendingWrites.isEmpty()) {
            this.inBuffer.clear();
            ByteBuffer byteBuffer = this.pendingWrites.peek();
            if (byteBuffer == STDIN_CLOSED_PENDING_WRITE_TOMBSTONE) {
                this.closeStdin(true);
                this.userWantsWrite.set(false);
                this.pendingWrites.clear();
                return false;
            }
            if (byteBuffer != null && byteBuffer.remaining() > 65536) {
                ByteBuffer slice = byteBuffer.slice();
                slice.limit(65536);
                this.inBuffer.put(slice);
                byteBuffer.position(byteBuffer.position() + 65536);
            } else if (byteBuffer != null) {
                this.inBuffer.put(byteBuffer);
                this.pendingWrites.poll();
            }
            this.inBuffer.flip();
            if (this.inBuffer.hasRemaining()) {
                if (availability <= 0) {
                    return true;
                }
                return this.writeStdin(availability, fd);
            }
        }
        if (!this.userWantsWrite.compareAndSet(true, false)) {
            return false;
        }
        try {
            this.inBuffer.clear();
            if (this.processHandler.onStdinReady(this.inBuffer)) {
                this.userWantsWrite.set(true);
            }
            if (this.inBuffer.hasRemaining() && availability > 0) {
                return this.writeStdin(availability, fd);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception thrown handling writes to stdin " + this.processHandler, e);
            return false;
        }
    }

    protected void afterStart() {
        long testSleep = Integer.getInteger("nuprocess.test.afterStartSleep", 0).intValue();
        if (testSleep > 0L) {
            LockSupport.parkNanos(testSleep);
        }
        this.isRunning = true;
    }

    protected void initializeBuffers() {
        this.outClosed = false;
        this.errClosed = false;
        this.pendingWrites = new ConcurrentLinkedQueue();
        this.outBufferMemory = new Memory(65536L);
        this.outBuffer = this.outBufferMemory.getByteBuffer(0L, this.outBufferMemory.size()).order(ByteOrder.nativeOrder());
        this.errBufferMemory = new Memory(65536L);
        this.errBuffer = this.errBufferMemory.getByteBuffer(0L, this.outBufferMemory.size()).order(ByteOrder.nativeOrder());
        this.inBufferMemory = new Memory(65536L);
        this.inBuffer = this.inBufferMemory.getByteBuffer(0L, this.outBufferMemory.size()).order(ByteOrder.nativeOrder());
        this.inBuffer.limit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerProcess() {
        IEventProcessor<? extends BasePosixProcess>[] iEventProcessorArray = processors;
        synchronized (processors) {
            int mySlot = processorRoundRobin;
            processorRoundRobin = (processorRoundRobin + 1) % processors.length;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            this.myProcessor = processors[mySlot];
            this.myProcessor.registerProcess(this);
            if (this.myProcessor.checkAndSetRunning()) {
                CyclicBarrier spawnBarrier = this.myProcessor.getSpawnBarrier();
                Thread t = new Thread(this.myProcessor, "ProcessQueue" + mySlot);
                t.setDaemon(true);
                t.start();
                try {
                    spawnBarrier.await();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return;
        }
    }

    protected void callPreStart() {
        try {
            this.processHandler.onPreStart(this);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception thrown from handler", e);
        }
    }

    protected void callStart() {
        try {
            this.processHandler.onStart(this);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception thrown from handler", e);
        }
    }

    protected int[] createPipes() {
        int[] in = new int[2];
        int[] out = new int[2];
        int[] err = new int[2];
        try {
            int rc = LibC.pipe(in);
            BasePosixProcess.checkReturnCode(rc, "Create stdin pipe() failed");
            rc = LibC.pipe(out);
            BasePosixProcess.checkReturnCode(rc, "Create stdout pipe() failed");
            rc = LibC.pipe(err);
            BasePosixProcess.checkReturnCode(rc, "Create stderr pipe() failed");
            this.setNonBlocking(in[1], out[0], err[0]);
            this.stdin = new ReferenceCountedFileDescriptor(in[1]);
            this.stdout = new ReferenceCountedFileDescriptor(out[0]);
            this.stderr = new ReferenceCountedFileDescriptor(err[0]);
            this.stdinWidow = in[0];
            this.stdoutWidow = out[1];
            this.stderrWidow = err[1];
            return new int[]{in[1], out[0], err[0]};
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.SEVERE, "Error creating pipes", e);
            this.initFailureCleanup(in, out, err);
            throw e;
        }
    }

    protected void initFailureCleanup(int[] in, int[] out, int[] err) {
        HashSet<Integer> unique = new HashSet<Integer>();
        unique.add(in[0]);
        unique.add(in[1]);
        unique.add(out[0]);
        unique.add(out[1]);
        unique.add(err[0]);
        unique.add(err[1]);
        unique.remove(0);
        Iterator iterator = unique.iterator();
        while (iterator.hasNext()) {
            int fd = (Integer)iterator.next();
            LibC.close(fd);
        }
    }

    protected static void checkReturnCode(int rc, String failureMessage) {
        if (rc != 0) {
            throw new RuntimeException(failureMessage + ", return code: " + rc + ", last error: " + Native.getLastError());
        }
    }

    private void setNonBlocking(int in, int out, int err) {
        int rc = LibC.fcntl(in, 4, LibC.fcntl(in, 3) | LibC.O_NONBLOCK);
        BasePosixProcess.checkReturnCode(rc, "fnctl on stdin handle failed");
        rc = LibC.fcntl(out, 4, LibC.fcntl(out, 3) | LibC.O_NONBLOCK);
        BasePosixProcess.checkReturnCode(rc, "fnctl on stdout handle failed");
        rc = LibC.fcntl(err, 4, LibC.fcntl(err, 3) | LibC.O_NONBLOCK);
        BasePosixProcess.checkReturnCode(rc, "fnctl on stderr handle failed");
    }

    static {
        STDIN_CLOSED_PENDING_WRITE_TOMBSTONE = ByteBuffer.allocate(1);
        IS_SOFTEXIT_DETECTION = Boolean.parseBoolean(System.getProperty("com.zaxxer.nuprocess.softExitDetection", "true"));
        processors = new IEventProcessor[Constants.NUMBER_OF_THREADS];
        if (Boolean.parseBoolean(System.getProperty("com.zaxxer.nuprocess.enableShutdownHook", "true"))) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    for (IEventProcessor<? extends BasePosixProcess> processor : processors) {
                        if (processor == null) continue;
                        processor.shutdown();
                    }
                }
            }));
        }
    }
}

