/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.codec;

import com.zaxxer.nuprocess.codec.NuCharsetEncoderHandler;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public final class NuCharsetEncoder {
    private final NuCharsetEncoderHandler handler;
    private final CharsetEncoder encoder;
    private final CharBuffer charBuffer;

    public NuCharsetEncoder(NuCharsetEncoderHandler handler, Charset charset) {
        this(handler, charset.newEncoder());
    }

    public NuCharsetEncoder(NuCharsetEncoderHandler handler, CharsetEncoder encoder) {
        this.handler = handler;
        this.encoder = encoder;
        this.charBuffer = CharBuffer.allocate(65536);
    }

    public boolean onStdinReady(ByteBuffer buffer) {
        boolean endOfInput = !this.handler.onStdinReady(this.charBuffer);
        CoderResult encoderResult = this.encoder.encode(this.charBuffer, buffer, endOfInput);
        buffer.flip();
        this.charBuffer.compact();
        if (encoderResult.isError()) {
            this.handler.onEncoderError(encoderResult);
        }
        if (encoderResult.isOverflow()) {
            return true;
        }
        if (endOfInput) {
            CoderResult flushResult = this.encoder.flush(buffer);
            return flushResult.isOverflow();
        }
        return true;
    }
}

