/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sdk;

import com.appdynamics.sdk.ADAppAgent;
import java.lang.reflect.Method;
import java.util.Map;

public class ReflectiveADAppAgent
implements ADAppAgent {
    private static final String CUSTOM_METRIC_PREFX = "Custom Metrics|";
    private final ErrorHandler errorHandler;
    private final Object publisher;
    private final Method observedMetricReporter;
    private final Method averageMetricReporter;
    private final Method sumMetricReporter;
    private final Method genericMetricReporter;
    private final Method infoEventReporter;
    private final Method errorEventReporter;

    public ReflectiveADAppAgent(ErrorHandler errorHandler) throws AgentConnectionException {
        Class<?> agentDelegateCls;
        this.errorHandler = errorHandler;
        try {
            agentDelegateCls = Class.forName("com.appdynamics.apm.appagent.api.AgentDelegate");
        }
        catch (ClassNotFoundException e) {
            throw new AgentConnectionException("Couldn't find AppD agent classes", e);
        }
        try {
            this.publisher = agentDelegateCls.getMethod("getMetricAndEventPublisher", new Class[0]).invoke(null, new Object[0]);
            Class<?> publisherCls = this.publisher.getClass();
            this.observedMetricReporter = publisherCls.getMethod("reportObservedMetric", String.class, Long.TYPE);
            this.averageMetricReporter = publisherCls.getMethod("reportAverageMetric", String.class, Long.TYPE);
            this.sumMetricReporter = publisherCls.getMethod("reportSumMetric", String.class, Long.TYPE);
            this.genericMetricReporter = publisherCls.getMethod("reportMetric", String.class, Long.TYPE, String.class, String.class, String.class);
            this.infoEventReporter = publisherCls.getMethod("publishInfoEvent", String.class, Map.class);
            this.errorEventReporter = publisherCls.getMethod("publishErrorEvent", String.class, Map.class, Boolean.TYPE);
        }
        catch (Throwable e) {
            throw new AgentConnectionException(e);
        }
    }

    @Override
    public void reportObservedMetric(String metricName, long metricValue) {
        try {
            this.observedMetricReporter.invoke(this.publisher, metricName, metricValue);
        }
        catch (Throwable t) {
            this.errorHandler.reportingFailed(t.getMessage(), t);
        }
    }

    @Override
    public void reportAverageMetric(String metricName, long metricValue) {
        try {
            this.averageMetricReporter.invoke(this.publisher, metricName, metricValue);
        }
        catch (Throwable t) {
            this.errorHandler.reportingFailed(t.getMessage(), t);
        }
    }

    @Override
    public void reportCountMetric(String metricName, long metricValue) {
        try {
            this.sumMetricReporter.invoke(this.publisher, metricName, metricValue);
        }
        catch (Throwable t) {
            this.errorHandler.reportingFailed(t.getMessage(), t);
        }
    }

    @Override
    public void reportMetric(String metricName, long metricValue, ADAppAgent.MetricAggregatorType aggregatorType, ADAppAgent.MetricTimeRollupType timeRollupType, ADAppAgent.MetricClusterRollupType clusterRollupType) {
        try {
            this.genericMetricReporter.invoke(this.publisher, CUSTOM_METRIC_PREFX + metricName, metricValue, aggregatorType.name(), timeRollupType.name(), clusterRollupType.name());
        }
        catch (Throwable t) {
            this.errorHandler.reportingFailed(t.getMessage(), t);
        }
    }

    @Override
    public void reportInfoEvent(String summaryMessage, Map<String, String> details) {
        try {
            this.infoEventReporter.invoke(this.publisher, summaryMessage, details);
        }
        catch (Throwable t) {
            this.errorHandler.reportingFailed(t.getMessage(), t);
        }
    }

    @Override
    public void reportErrorEvent(String summaryMessage, Map<String, String> details, boolean critical) {
        try {
            this.errorEventReporter.invoke(this.publisher, summaryMessage, details, critical);
        }
        catch (Throwable t) {
            this.errorHandler.reportingFailed(t.getMessage(), t);
        }
    }

    public static class AgentConnectionException
    extends Exception {
        public AgentConnectionException(String message, Throwable cause) {
            super(message, cause);
        }

        public AgentConnectionException(Throwable cause) {
            super(cause);
        }
    }

    public static interface ErrorHandler {
        public void reportingFailed(String var1, Throwable var2);
    }
}

