/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.eclipse.jetty.util.Index;

public class ContextRoutingHandler
extends AbstractHandlerContainer {
    private final Index<Handler> handlers;

    public ContextRoutingHandler(Map<String, ? extends Handler> handlers) {
        Index.Builder builder = new Index.Builder().caseSensitive(false);
        for (Map.Entry<String, ? extends Handler> entry : handlers.entrySet()) {
            builder.with(entry.getKey(), (Object)entry.getValue());
            this.addBean(entry.getValue());
        }
        this.handlers = builder.build();
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Handler handler = (Handler)this.handlers.getBest(baseRequest.getRequestURI());
        if (handler != null) {
            handler.handle(target, baseRequest, request, response);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        for (String key : this.handlers.keySet()) {
            ((Handler)this.handlers.get(key)).start();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        for (String key : this.handlers.keySet()) {
            ((Handler)this.handlers.get(key)).stop();
        }
    }

    public Handler[] getHandlers() {
        return (Handler[])this.handlers.keySet().stream().map(arg_0 -> this.handlers.get(arg_0)).toArray(Handler[]::new);
    }

    protected void expandChildren(List<Handler> list, Class<?> byClass) {
        Handler[] handlerArray = this.getHandlers();
        if (handlerArray != null) {
            for (Handler h : handlerArray) {
                this.expandHandler(h, list, byClass);
            }
        }
    }
}

