/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava;

import com.github.mustachejava.DefaultMustacheVisitor;
import com.github.mustachejava.FragmentKey;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.MustacheFactory;
import com.github.mustachejava.MustacheParser;
import com.github.mustachejava.MustacheVisitor;
import com.github.mustachejava.ObjectHandler;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.reflect.ReflectionObjectHandler;
import com.github.mustachejava.util.HtmlEscaper;
import com.google.common.base.Charsets;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class DefaultMustacheFactory
implements MustacheFactory {
    protected final LoadingCache<String, Mustache> mustacheCache = this.createMustacheCache();
    protected ObjectHandler oh = new ReflectionObjectHandler();
    protected final MustacheParser mc = new MustacheParser(this);
    protected final LoadingCache<FragmentKey, Mustache> templateCache = this.createLambdaCache();
    protected int recursionLimit = 100;
    private final String resourceRoot;
    private final File fileRoot;
    protected ListeningExecutorService les;
    private final ThreadLocal<Map<String, Mustache>> partialCache = new ThreadLocal<Map<String, Mustache>>(){

        @Override
        protected Map<String, Mustache> initialValue() {
            return new HashMap<String, Mustache>();
        }
    };

    public DefaultMustacheFactory() {
        this.resourceRoot = null;
        this.fileRoot = null;
    }

    public DefaultMustacheFactory(String resourceRoot) {
        if (!resourceRoot.endsWith("/")) {
            resourceRoot = resourceRoot + "/";
        }
        this.resourceRoot = resourceRoot;
        this.fileRoot = null;
    }

    public DefaultMustacheFactory(File fileRoot) {
        if (!fileRoot.exists()) {
            throw new MustacheException(fileRoot + " does not exist");
        }
        if (!fileRoot.isDirectory()) {
            throw new MustacheException(fileRoot + " is not a directory");
        }
        this.fileRoot = fileRoot;
        this.resourceRoot = null;
    }

    public String resolvePartialPath(String dir, String name, String extension) {
        String path = name.startsWith("/") ? Files.simplifyPath((String)new File(name + extension).getPath()) : Files.simplifyPath((String)new File(dir + name + extension).getPath());
        return DefaultMustacheFactory.ensureForwardSlash(path);
    }

    private static String ensureForwardSlash(String path) {
        return path.replace('\\', '/');
    }

    @Override
    public MustacheVisitor createMustacheVisitor() {
        return new DefaultMustacheVisitor(this);
    }

    @Override
    public Reader getReader(String resourceName) {
        String name;
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        InputStream is = ccl.getResourceAsStream(name = (this.resourceRoot == null ? "" : this.resourceRoot) + resourceName);
        if (is == null) {
            is = DefaultMustacheFactory.class.getClassLoader().getResourceAsStream(name);
        }
        if (is == null) {
            File file;
            File file2 = file = this.fileRoot == null ? new File(resourceName) : new File(this.fileRoot, resourceName);
            if (file.exists() && file.isFile()) {
                try {
                    File checkRoot = this.fileRoot == null ? new File("").getCanonicalFile() : this.fileRoot.getCanonicalFile();
                    File parent = file.getCanonicalFile();
                    while ((parent = parent.getParentFile()) != null && !parent.equals(checkRoot)) {
                    }
                    if (parent == null) {
                        throw new MustacheException("File not under root: " + checkRoot.getAbsolutePath());
                    }
                    is = new FileInputStream(file);
                }
                catch (IOException e) {
                    throw new MustacheException("Found file, could not open: " + file, e);
                }
            }
        }
        if (is == null) {
            throw new MustacheException("Template '" + resourceName + "' not found");
        }
        return new BufferedReader(new InputStreamReader(is, Charsets.UTF_8));
    }

    @Override
    public void encode(String value, Writer writer) {
        HtmlEscaper.escape(value, writer, true);
    }

    @Override
    public ObjectHandler getObjectHandler() {
        return this.oh;
    }

    public void setObjectHandler(ObjectHandler oh) {
        this.oh = oh;
    }

    public ExecutorService getExecutorService() {
        return this.les;
    }

    public void setExecutorService(ExecutorService es) {
        this.les = es instanceof ListeningExecutorService ? (ListeningExecutorService)es : MoreExecutors.listeningDecorator((ExecutorService)es);
    }

    public Mustache getFragment(FragmentKey templateKey) {
        try {
            Mustache mustache = (Mustache)this.templateCache.get((Object)templateKey);
            mustache.init();
            return mustache;
        }
        catch (ExecutionException e) {
            throw this.handle(e);
        }
    }

    private MustacheException handle(Exception e) {
        Throwable cause = e.getCause();
        if (cause instanceof MustacheException) {
            return (MustacheException)cause;
        }
        return new MustacheException(cause);
    }

    @Override
    public Mustache compile(String name) {
        try {
            Mustache mustache = (Mustache)this.mustacheCache.get((Object)name);
            mustache.init();
            return mustache;
        }
        catch (UncheckedExecutionException e) {
            throw this.handle((Exception)((Object)e));
        }
        catch (ExecutionException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Mustache compile(Reader reader, String name) {
        return this.compile(reader, name, "{{", "}}");
    }

    public Mustache compile(Reader reader, String file, String sm, String em) {
        Mustache compile = this.mc.compile(reader, file, sm, em);
        compile.init();
        return compile;
    }

    @Override
    public String translate(String from) {
        return from;
    }

    public String filterText(String appended, boolean b) {
        return appended;
    }

    public void setRecursionLimit(int recursionLimit) {
        this.recursionLimit = recursionLimit;
    }

    public int getRecursionLimit() {
        return this.recursionLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mustache compilePartial(String s) {
        Map<String, Mustache> cache = this.partialCache.get();
        try {
            Mustache mustache = cache.get(s);
            if (mustache == null) {
                mustache = this.mc.compile(s);
                cache.put(s, mustache);
                mustache.init();
            }
            Mustache mustache2 = mustache;
            return mustache2;
        }
        finally {
            cache.remove(s);
        }
    }

    protected LoadingCache<String, Mustache> createMustacheCache() {
        return CacheBuilder.newBuilder().build((CacheLoader)new MustacheCacheLoader());
    }

    protected LoadingCache<FragmentKey, Mustache> createLambdaCache() {
        return CacheBuilder.newBuilder().build((CacheLoader)new FragmentCacheLoader());
    }

    protected class FragmentCacheLoader
    extends CacheLoader<FragmentKey, Mustache> {
        protected FragmentCacheLoader() {
        }

        public Mustache load(FragmentKey fragmentKey) throws Exception {
            StringReader reader = new StringReader(fragmentKey.templateText);
            TemplateContext tc = fragmentKey.tc;
            return DefaultMustacheFactory.this.mc.compile(reader, tc.file(), tc.startChars(), tc.endChars(), tc.startOfLine());
        }
    }

    protected class MustacheCacheLoader
    extends CacheLoader<String, Mustache> {
        protected MustacheCacheLoader() {
        }

        public Mustache load(String key) throws Exception {
            return DefaultMustacheFactory.this.mc.compile(key);
        }
    }
}

