/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.queue;

import com.appdynamics.analytics.queue.QueueConfiguration;
import java.util.AbstractQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Queues {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Queues.class);
    private final ConcurrentMap<Object, BlockingQueue<?>> queues = new ConcurrentHashMap();

    Queues() {
    }

    ConcurrentMap<Object, BlockingQueue<?>> getQueues() {
        return this.queues;
    }

    public <I> BlockingQueue<I> findOrSetupQueue(QueueConfiguration qConf) {
        AbstractQueue queue = null;
        int qSize = qConf.getQueueSize();
        switch (qSize) {
            case 0: {
                queue = new SynchronousQueue();
                break;
            }
            case 0x7FFFFFFF: {
                queue = new LinkedBlockingQueue();
                break;
            }
            default: {
                queue = new ArrayBlockingQueue(qConf.getQueueSize());
            }
        }
        BlockingQueue oldQueue = this.queues.putIfAbsent(qConf.getQueueName(), (BlockingQueue<?>)((Object)queue));
        if (oldQueue != null) {
            log.debug("Queue [" + qConf.getQueueName() + "] already exists and so this configuration will be ignored");
            return oldQueue;
        }
        log.debug("Queue [" + qConf.getQueueName() + "] created with max size [{}]", (Object)qConf.getQueueSize());
        return queue;
    }

    public <I> BlockingQueue<I> getQueue(Object key) {
        BlockingQueue bq = (BlockingQueue)this.queues.get(key);
        return bq;
    }

    public <I> BlockingQueue<I> removeQueue(Object key) {
        BlockingQueue bq = (BlockingQueue)this.queues.remove(key);
        return bq;
    }
}

