/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.time;

import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.util.AbstractPipelineStage;
import com.appdynamics.analytics.pipeline.xform.time.TimestampFilterHelpers;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TimestampFilterStage
extends AbstractPipelineStage<Map<String, Object>, Map<String, Object>> {
    final String source;
    final long collectLastMilliseconds;

    TimestampFilterStage(PipelineStageParameters<Map<String, Object>> parameters, String source, int collectLastNHours) {
        super(parameters);
        this.source = source;
        this.collectLastMilliseconds = TimeUnit.HOURS.toMillis(collectLastNHours);
    }

    @Override
    public void process(Map<String, Object> input) {
        long timestamp;
        long currentTime = System.currentTimeMillis();
        if (!TimestampFilterHelpers.shouldDiscard(this.collectLastMilliseconds, currentTime, timestamp = ((Long)input.get("eventTimestamp")).longValue())) {
            this.invokeNext(input);
        }
    }
}

