/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.time;

import com.appdynamics.analytics.pipeline.api.PipelineStage;
import com.appdynamics.analytics.pipeline.util.PipelineHelper;
import com.appdynamics.analytics.pipeline.xform.time.DateTimeExtractorConfiguration;
import com.appdynamics.analytics.pipeline.xform.time.DateTimeExtractorStage;
import com.appdynamics.analytics.pipeline.xform.time.DateTimeExtractorStageFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="debug/timestamp")
@Produces(value={"text/plain"})
public class DateTimeExtractorStageResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DateTimeExtractorStageResource.class);
    private DateTimeExtractorStageFactory dateTimeExtractorStageFactory;

    public DateTimeExtractorStageResource(DateTimeExtractorStageFactory factory) {
        this.dateTimeExtractorStageFactory = factory;
    }

    @GET
    public String usage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Usage:\n").append("curl -XPOST http://localhost:9090/debug/timestamp --data-urlencode \"logLine=LOG_LINE\"").append(" --data-urlencode \"pattern=PATTERN\"\n");
        return sb.toString();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public String postTimestampParsing(@FormParam(value="logLine") String logLine, @FormParam(value="pattern") String pattern) {
        try {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)logLine) ? 1 : 0) != 0, (Object)"'logLine' should be provided");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)pattern) ? 1 : 0) != 0, (Object)"'pattern' should be provided");
            DateTimeExtractorConfiguration stageConfiguration = new DateTimeExtractorConfiguration();
            stageConfiguration.setPattern(pattern);
            PipelineStage stage = this.dateTimeExtractorStageFactory.create(PipelineHelper.parameters(null, null, stageConfiguration));
            log.info("DateTimeExtractor stage created successfully for pattern [{}]", (Object)pattern);
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("message", logLine);
            ((DateTimeExtractorStage)stage).process((Map<String, Object>)input);
            StringBuffer output = new StringBuffer();
            output.append("{\n");
            output.append(" ").append("eventTimestamp").append(" => ").append(input.get("eventTimestamp")).append("\n");
            output.append("}\n");
            return output.toString();
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).type(MediaType.TEXT_PLAIN_TYPE).build());
        }
        catch (RuntimeException e) {
            log.error("Error occurred while parsing the timestamp pattern", (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).type(MediaType.TEXT_PLAIN_TYPE).build());
        }
    }
}

