/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.time;

import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.util.AbstractPipelineStage;
import com.appdynamics.common.util.configuration.ConfigurationException;
import com.appdynamics.common.util.datetime.FastDateTimeParser;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

class DateTimeExtractorStage
extends AbstractPipelineStage<Map<String, Object>, Map<String, Object>> {
    final String sourceField;
    final String destinationField;
    private FastDateTimeParser optParser;

    DateTimeExtractorStage(PipelineStageParameters<Map<String, Object>> parameters, String sourceField, String destinationField, String overrideTimeZone, String pattern) {
        super(parameters);
        this.sourceField = sourceField;
        this.destinationField = destinationField;
        this.optParser = null;
        if (pattern != null) {
            try {
                DateTimeFormatter formatter = DateTimeFormat.forPattern((String)pattern).withDefaultYear(new DateTime().getYear());
                if (overrideTimeZone != null) {
                    formatter = formatter.withZone(DateTimeZone.forID((String)overrideTimeZone));
                    this.optParser = new FastDateTimeParser(formatter);
                } else {
                    this.optParser = new FastDateTimeParser(formatter);
                }
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Error occurred while preparing the date time extractor. The pattern [" + pattern + "] appears to be invalid", (Throwable)e);
            }
        }
    }

    @Override
    public void process(Map<String, Object> input) {
        Object destField = input.get(this.destinationField);
        String preParsedTimestamp = null;
        if (destField != null) {
            preParsedTimestamp = input.get(this.destinationField).toString();
        }
        String source = preParsedTimestamp != null ? preParsedTimestamp : input.get(this.sourceField).toString();
        long timestamp = -1L;
        if (source != null && this.optParser != null) {
            this.optParser.reset(source);
            timestamp = this.optParser.next();
        }
        long currentTime = System.currentTimeMillis();
        if (timestamp == -1L) {
            String pickupTimestamp = null;
            if (input.get("pickupTimestamp") != null) {
                pickupTimestamp = input.get("pickupTimestamp").toString();
            }
            if (pickupTimestamp == null) {
                timestamp = currentTime;
            } else {
                input.put(this.destinationField, pickupTimestamp);
            }
        }
        if (timestamp <= TimeUnit.DAYS.toMillis(2L) && timestamp != -1L) {
            DateTime today = new DateTime(DateTimeZone.UTC).withTimeAtStartOfDay();
            timestamp += today.getMillis();
        }
        if (timestamp != -1L) {
            input.put(this.destinationField, timestamp);
        }
        this.invokeNext(input);
    }
}

