/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.regex;

import com.appdynamics.analytics.pipeline.util.FieldValueHelper;
import com.appdynamics.analytics.pipeline.xform.map.PositionalFieldInfo;
import com.appdynamics.common.util.charsequence.InterruptibleCharSequence;
import com.appdynamics.common.util.regex.RegexPattern;
import com.appdynamics.common.util.type.ValueType;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.exceptions.Exceptions;

public class RegexUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegexUtils.class);

    public static int matchAndExtract(RegexPattern[] regexPatterns, Matcher[] matchers, Map<String, Object> input, InterruptibleCharSequence candidate) {
        int matchCount = 0;
        for (int i = 0; i < regexPatterns.length; ++i) {
            RegexPattern pattern = regexPatterns[i];
            Matcher reusableMatcher = matchers[i];
            reusableMatcher.reset((CharSequence)candidate);
            int[] captureGroupIds = pattern.getAliasGroupIds();
            String[] captureGroupNames = pattern.getAliases();
            ValueType[] valueTypes = pattern.getValueTypes();
            try {
                while (reusableMatcher.find()) {
                    for (int j = 0; j < captureGroupIds.length; ++j) {
                        ValueType valueType;
                        Object castedValue;
                        int captureGroupId = captureGroupIds[j];
                        String captureGroupValue = reusableMatcher.group(captureGroupId);
                        int startIndex = reusableMatcher.start(captureGroupId);
                        int endIndex = reusableMatcher.end(captureGroupId);
                        if (captureGroupValue == null || (castedValue = FieldValueHelper.cast(captureGroupNames[j], captureGroupValue, valueType = valueTypes[j])) == null) continue;
                        input.put(captureGroupNames[j], new PositionalFieldInfo(castedValue, startIndex, endIndex));
                        ++matchCount;
                    }
                }
                continue;
            }
            catch (RuntimeException e) {
                Throwable cause = Exceptions.getFinalCause((Throwable)e);
                if (cause instanceof TimeoutException) {
                    log.error(e.getMessage());
                    continue;
                }
                throw e;
            }
        }
        return matchCount;
    }
}

