/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.regex;

import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.util.AbstractPipelineStageFactory;
import com.appdynamics.analytics.pipeline.xform.Constants;
import com.appdynamics.analytics.pipeline.xform.grok.RegexStage;
import com.appdynamics.analytics.pipeline.xform.regex.RegexPattern;
import com.appdynamics.analytics.pipeline.xform.regex.RegexStageConfiguration;
import com.appdynamics.analytics.pipeline.xform.regex.RegexStageFactoryConfiguration;
import com.appdynamics.common.util.grok.Grok;
import com.appdynamics.common.util.type.ValueType;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexStageFactory
extends AbstractPipelineStageFactory<Map<String, Object>, Map<String, Object>, RegexStageFactoryConfiguration, RegexStageConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegexStageFactory.class);
    @Inject
    private volatile Grok grok;

    public RegexStage create(PipelineStageParameters<Map<String, Object>> parameters) {
        RegexStageConfiguration stageConfiguration = (RegexStageConfiguration)this.extract(parameters);
        String source = stageConfiguration.mergeSourceAndValidate(((RegexStageFactoryConfiguration)this.getConfiguration()).getSource());
        List<RegexPattern> configPatterns = stageConfiguration.getRegexPatterns();
        HashMap<String, ValueType> aliasTypeMap = new HashMap<String, ValueType>();
        for (RegexPattern rp : configPatterns) {
            for (int i = 0; i < rp.getAlias().length; ++i) {
                aliasTypeMap.put(rp.getAlias()[i], rp.getValueType()[i]);
            }
        }
        ArrayList<com.appdynamics.common.util.regex.RegexPattern> regexPatterns = new ArrayList<com.appdynamics.common.util.regex.RegexPattern>(configPatterns.size());
        for (RegexPattern pattern : configPatterns) {
            com.appdynamics.common.util.regex.RegexPattern regexPattern = this.grok.compile(pattern.getRegex());
            ValueType[] vta = new ValueType[regexPattern.getAliases().length];
            for (int i = 0; i < regexPattern.getAliases().length; ++i) {
                vta[i] = aliasTypeMap.containsKey(regexPattern.getAliases()[i]) ? (ValueType)aliasTypeMap.get(regexPattern.getAliases()[i]) : ValueType.UNKNOWN;
            }
            regexPattern.setValueTypes(vta);
            ArrayList<String> alteredFields = new ArrayList<String>();
            for (String reservedField : Constants.RESERVED_FIELDS) {
                if (!regexPattern.removeByAlias(reservedField)) continue;
                alteredFields.add(reservedField);
            }
            if (!alteredFields.isEmpty()) {
                log.warn("The following reserved fields [{}] were removed from the given regex pattern [{}]", alteredFields, (Object)pattern);
            }
            regexPatterns.add(regexPattern);
        }
        return new RegexStage(parameters, source, regexPatterns);
    }

    @Generated
    public void setGrok(Grok grok) {
        this.grok = grok;
    }
}

