/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.regex;

import com.appdynamics.analytics.pipeline.xform.regex.RegexPattern;
import com.appdynamics.common.util.configuration.ConfigurationException;
import com.appdynamics.common.util.configuration.ManualValidateable;
import com.appdynamics.common.util.configuration.ManualValidated;
import com.google.common.base.MoreObjects;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;

@ManualValidated
public class RegexStageConfiguration
implements ManualValidateable {
    private String source = "message";
    @NotNull
    @NotEmpty
    private List<RegexPattern> regexPatterns;

    public String mergeSourceAndValidate(String thatOptSource) {
        try {
            this.source = (String)MoreObjects.firstNonNull((Object)this.source, (Object)thatOptSource);
        }
        catch (NullPointerException e) {
            throw new ConfigurationException("The [source] field has not been specified", (Throwable)e);
        }
        return this.source;
    }

    public boolean validate(ConstraintValidatorContext context) {
        TreeSet<String> allAliases = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (RegexPattern pattern : this.regexPatterns) {
            String duplicateField;
            if (pattern == null || (duplicateField = this.addAliases(pattern, allAliases)) == null) continue;
            context.buildConstraintViolationWithTemplate(String.format("Attempt has been made to extract field [%s] twice.", duplicateField)).addPropertyNode("patterns").addConstraintViolation();
            return false;
        }
        return true;
    }

    private String addAliases(RegexPattern pattern, Set<String> aliases) {
        for (String alias : pattern.getAlias()) {
            if (aliases.add(alias)) continue;
            return alias;
        }
        return null;
    }

    @Generated
    public RegexStageConfiguration() {
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public List<RegexPattern> getRegexPatterns() {
        return this.regexPatterns;
    }

    @Generated
    public void setSource(String source) {
        this.source = source;
    }

    @Generated
    public void setRegexPatterns(List<RegexPattern> regexPatterns) {
        this.regexPatterns = regexPatterns;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegexStageConfiguration)) {
            return false;
        }
        RegexStageConfiguration other = (RegexStageConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        List<RegexPattern> this$regexPatterns = this.getRegexPatterns();
        List<RegexPattern> other$regexPatterns = other.getRegexPatterns();
        return !(this$regexPatterns == null ? other$regexPatterns != null : !((Object)this$regexPatterns).equals(other$regexPatterns));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RegexStageConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        List<RegexPattern> $regexPatterns = this.getRegexPatterns();
        result = result * 59 + ($regexPatterns == null ? 43 : ((Object)$regexPatterns).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RegexStageConfiguration(source=" + this.getSource() + ", regexPatterns=" + String.valueOf(this.getRegexPatterns()) + ")";
    }
}

