/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.keyvalue;

import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.util.AbstractPipelineStageFactory;
import com.appdynamics.analytics.pipeline.xform.Constants;
import com.appdynamics.analytics.pipeline.xform.keyvalue.KeyValueStage;
import com.appdynamics.analytics.pipeline.xform.keyvalue.KeyValueStageConfiguration;
import com.appdynamics.analytics.pipeline.xform.keyvalue.KeyValueStageFactoryConfiguration;
import com.appdynamics.analytics.pipeline.xform.keyvalue.LogFieldMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueStageFactory
extends AbstractPipelineStageFactory<Map<String, Object>, Map<String, Object>, KeyValueStageFactoryConfiguration, KeyValueStageConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KeyValueStageFactory.class);

    public KeyValueStage create(PipelineStageParameters<Map<String, Object>> parameters) {
        KeyValueStageConfiguration cfg = (KeyValueStageConfiguration)this.extract(parameters);
        String message = cfg.mergeSourceAndValidate(((KeyValueStageFactoryConfiguration)this.getConfiguration()).getSource());
        Map<String, LogFieldMetadata> keyToField = cfg.getKeyToField();
        List<String> include = cfg.getInclude();
        ArrayList<String> addNonRestrictedFields = new ArrayList<String>();
        if (include != null && !include.isEmpty()) {
            for (String field : include) {
                if (!Constants.RESERVED_FIELDS.contains(field.toLowerCase(Locale.ROOT))) {
                    addNonRestrictedFields.add(field);
                    continue;
                }
                log.warn("The field [{}] is a reserved field. It can't be extracted as a key.", (Object)field);
            }
        }
        if (keyToField != null && !keyToField.isEmpty()) {
            ArrayList<String> removeRestrictedFields = new ArrayList<String>();
            for (Map.Entry<String, LogFieldMetadata> keyValue : keyToField.entrySet()) {
                String key = keyValue.getValue().getFieldName();
                if (!Constants.RESERVED_FIELDS.contains(key.toLowerCase(Locale.ROOT))) continue;
                removeRestrictedFields.add(keyValue.getKey());
            }
            for (String field : removeRestrictedFields) {
                keyToField.remove(field);
                log.warn("The field [{}] is a reserved field. It can't be extracted as a key.", (Object)field);
            }
        }
        return new KeyValueStage(parameters, message, cfg.getSource(), cfg.getSeparators(), cfg.getSplits(), cfg.getTrim(), addNonRestrictedFields, keyToField);
    }
}

