/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.guid;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.nio.charset.Charset;
import java.util.Random;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogAnalyticsDecryptionUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogAnalyticsDecryptionUtil.class);
    private final Random random = new Random();
    private final ThreadLocal<Cipher> threadCipher;
    private final byte[] aesKey;
    private final SecretKeySpec secretKey;
    private static final int AES_KEY_SIZE_BYTES = 16;
    private static final int AES_BLOCK_SIZE_BYTES = 16;
    private static final int SALT_SIZE_BYTES = 8;
    private static final int PLAINTEXT_SIZE_BLOCKS = 1;
    private static final int PLAINTEXT_SIZE_BYTES = 16;
    private static final String CIPHER_NAME = "AES";
    private static final String CIPHER_NAME_BLOCK_PADDING = "AES/ECB/NoPadding";

    public LogAnalyticsDecryptionUtil(String key) {
        this.aesKey = String.format("%-16.16s", key).replace(' ', 'x').getBytes(Charset.defaultCharset());
        this.secretKey = new SecretKeySpec(this.aesKey, CIPHER_NAME);
        this.threadCipher = new ThreadLocal();
    }

    public String decrypt(String ciphertext) {
        byte[] decodedCiphertextPlusSalt;
        Cipher cipher;
        Cipher c;
        if (this.threadCipher.get() == null && (c = this.createCipher()) != null) {
            this.threadCipher.set(c);
        }
        if ((cipher = this.threadCipher.get()) != null && (decodedCiphertextPlusSalt = Base64.decodeBase64((String)ciphertext)) != null && decodedCiphertextPlusSalt.length >= 24) {
            try {
                cipher.doFinal(decodedCiphertextPlusSalt, 0, 16, decodedCiphertextPlusSalt);
            }
            catch (Exception e) {
                log.error("AES decryption failed for log guid injection", (Throwable)e);
                this.reinitCipher(cipher, 2);
                return null;
            }
            ByteBuffer bb = ByteBuffer.wrap(decodedCiphertextPlusSalt);
            LongBuffer lb = bb.asLongBuffer();
            long saltedMsb = lb.get(0);
            long saltedLsb = lb.get(1);
            long salt = lb.get(2);
            long msb = saltedMsb ^ salt;
            long lsb = saltedLsb ^ salt;
            UUID uuid = new UUID(msb, lsb);
            return uuid.toString();
        }
        return null;
    }

    private Cipher createCipher() {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(CIPHER_NAME_BLOCK_PADDING);
            SecretKeySpec k = new SecretKeySpec(this.aesKey, CIPHER_NAME);
            cipher.init(2, k);
        }
        catch (Exception e) {
            log.error("Creation of LogAnalyticsDecryptionUtil Cipher failed: " + String.valueOf(e));
        }
        return cipher;
    }

    private void reinitCipher(Cipher cipher, int cipherMode) {
        try {
            cipher.init(cipherMode, this.secretKey);
        }
        catch (Exception e) {
            log.error("LogAnalyticsDecryptionUtil: Failed to re-init cipher");
        }
    }
}

