/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.grok;

import com.appdynamics.analytics.pipeline.api.PipelineStage;
import com.appdynamics.analytics.pipeline.util.PipelineHelper;
import com.appdynamics.analytics.pipeline.xform.grok.GrokStageConfiguration;
import com.appdynamics.analytics.pipeline.xform.grok.GrokStageFactory;
import com.appdynamics.analytics.pipeline.xform.grok.RegexStage;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="debug/grok")
@Produces(value={"text/plain"})
public class GrokStageResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrokStageResource.class);
    private GrokStageFactory grokStageFactory;

    public GrokStageResource(GrokStageFactory factory) {
        this.grokStageFactory = factory;
    }

    @GET
    public String usage() {
        return "Usage:\nSingle line log: curl -v -XPOST http://localhost:9090/debug/grok --data-urlencode \"logLine=LOG_LINE\" --data-urlencode \"pattern=PATTERN\"\nMulti line log: curl -v -XPOST http://localhost:9090/debug/grok --data-urlencode \"logLine=`cat FILE_NAME`\" --data-urlencode \"pattern=PATTERN\"\n";
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public String postGrokParsing(@FormParam(value="logLine") String logLine, @FormParam(value="pattern") String pattern) {
        try {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)logLine) ? 1 : 0) != 0, (Object)"'logLine' should be provided");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)pattern) ? 1 : 0) != 0, (Object)"'pattern' should be provided");
            GrokStageConfiguration stageConfiguration = new GrokStageConfiguration();
            stageConfiguration.setPattern(pattern);
            PipelineStage stage = this.grokStageFactory.create(PipelineHelper.parameters(null, null, stageConfiguration));
            log.info("grok stage created successfully for pattern [{}]", (Object)pattern);
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("message", logLine);
            ((RegexStage)stage).process((Map<String, Object>)input);
            StringBuilder output = new StringBuilder();
            output.append("{\n");
            for (Map.Entry entry : input.entrySet()) {
                if (((String)entry.getKey()).equals("message")) continue;
                output.append(" ").append((String)entry.getKey()).append(" => ").append(entry.getValue()).append("\n");
            }
            output.append("}\n");
            return output.toString();
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).type(MediaType.TEXT_PLAIN_TYPE).build());
        }
        catch (RuntimeException e) {
            log.error("Error occurred while parsing the grok pattern", (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).type(MediaType.TEXT_PLAIN_TYPE).build());
        }
    }
}

