/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.field;

import com.appdynamics.analytics.pipeline.xform.field.FieldTypeConversionConfiguration;
import com.appdynamics.common.util.configuration.ManualValidateable;
import com.appdynamics.common.util.configuration.ManualValidated;
import com.appdynamics.common.util.type.ValueType;
import com.google.common.base.Strings;
import jakarta.validation.ConstraintValidatorContext;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManualValidated
public class FieldTypeConversionStageConfiguration
implements ManualValidateable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FieldTypeConversionStageConfiguration.class);
    private List<FieldTypeConversionConfiguration> fields;

    public boolean validate(ConstraintValidatorContext context) {
        ArrayList<FieldTypeConversionConfiguration> fieldTypeConversionConfiguration = new ArrayList<FieldTypeConversionConfiguration>();
        if (this.fields != null && !this.fields.isEmpty()) {
            for (FieldTypeConversionConfiguration fieldTypeConversionConfig : this.fields) {
                if (Strings.isNullOrEmpty((String)fieldTypeConversionConfig.getField())) {
                    context.buildConstraintViolationWithTemplate("The field name must be specified").addPropertyNode("FieldTransformation.field").addConstraintViolation();
                    return false;
                }
                if (fieldTypeConversionConfig.getType() == null || fieldTypeConversionConfig.getType() == ValueType.TIMESTAMP && Strings.isNullOrEmpty((String)fieldTypeConversionConfig.getFormat())) {
                    context.buildConstraintViolationWithTemplate(String.format("If type is equal to [%s] then the format field must be specified", ValueType.TIMESTAMP)).addPropertyNode("FieldTransformation.type / FieldTransformation.format").addConstraintViolation();
                    return false;
                }
                if (!fieldTypeConversionConfig.getField().equalsIgnoreCase("message")) continue;
                fieldTypeConversionConfiguration.add(fieldTypeConversionConfig);
                log.info("Removing FieldTypeConversionCOnfiguration [{}] because it's trying to modify the message field which is not allowed", (Object)fieldTypeConversionConfig);
            }
            for (FieldTypeConversionConfiguration fieldTypeConversionConfig : fieldTypeConversionConfiguration) {
                this.fields.remove(fieldTypeConversionConfig);
            }
        }
        return true;
    }

    @Generated
    public FieldTypeConversionStageConfiguration() {
    }

    @Generated
    public List<FieldTypeConversionConfiguration> getFields() {
        return this.fields;
    }

    @Generated
    public void setFields(List<FieldTypeConversionConfiguration> fields) {
        this.fields = fields;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldTypeConversionStageConfiguration)) {
            return false;
        }
        FieldTypeConversionStageConfiguration other = (FieldTypeConversionStageConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<FieldTypeConversionConfiguration> this$fields = this.getFields();
        List<FieldTypeConversionConfiguration> other$fields = other.getFields();
        return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FieldTypeConversionStageConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<FieldTypeConversionConfiguration> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FieldTypeConversionStageConfiguration(fields=" + String.valueOf(this.getFields()) + ")";
    }
}

