/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.field;

import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.util.AbstractPipelineStage;
import com.appdynamics.analytics.pipeline.util.FieldValueHelper;
import com.appdynamics.analytics.pipeline.xform.field.FieldTypeConversionConfiguration;
import com.appdynamics.analytics.pipeline.xform.map.PositionalFieldInfo;
import com.appdynamics.common.util.type.ValueType;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldTypeConversionStage
extends AbstractPipelineStage<Map<String, Object>, Map<String, Object>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FieldTypeConversionStage.class);
    private final List<FieldTypeConversionConfiguration> fields;

    public FieldTypeConversionStage(PipelineStageParameters<Map<String, Object>> parameters, List<FieldTypeConversionConfiguration> fields) {
        super(parameters);
        this.fields = fields;
    }

    @Override
    public void process(Map<String, Object> input) {
        log.debug("The input to the Field Type Conversion stage is [{}] ", input);
        this.fieldTypeConversion(input);
        this.invokeNext(input);
    }

    private void fieldTypeConversion(Map<String, Object> input) {
        if (this.fields == null || this.fields.isEmpty()) {
            log.debug("No fields specified for type conversion.");
        } else {
            for (FieldTypeConversionConfiguration fieldTypeConversionConfiguration : this.fields) {
                String field = fieldTypeConversionConfiguration.getField();
                ValueType valueType = fieldTypeConversionConfiguration.getType();
                String format = fieldTypeConversionConfiguration.getFormat();
                if (!input.containsKey(field)) continue;
                Object fieldValue = input.get(field);
                if (valueType == null || valueType == ValueType.UNKNOWN || fieldValue == null) continue;
                Object castedFieldValue = FieldValueHelper.cast(field, fieldValue.toString(), valueType, format);
                if (castedFieldValue != null) {
                    if (fieldValue instanceof PositionalFieldInfo) {
                        PositionalFieldInfo positionalFieldValue = (PositionalFieldInfo)fieldValue;
                        input.put(field, new PositionalFieldInfo(castedFieldValue, positionalFieldValue.getStart(), positionalFieldValue.getEnd()));
                        continue;
                    }
                    input.put(field, castedFieldValue);
                    continue;
                }
                input.remove(field);
            }
        }
    }
}

