/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.field;

import com.appdynamics.analytics.pipeline.xform.field.FieldRenameConfiguration;
import com.appdynamics.common.util.configuration.ManualValidateable;
import com.appdynamics.common.util.configuration.ManualValidated;
import com.google.common.base.Strings;
import jakarta.validation.ConstraintValidatorContext;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManualValidated
public class FieldRenameStageConfiguration
implements ManualValidateable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FieldRenameStageConfiguration.class);
    private List<FieldRenameConfiguration> fields;

    public boolean validate(ConstraintValidatorContext context) {
        ArrayList<FieldRenameConfiguration> fieldRenameConfiguration = new ArrayList<FieldRenameConfiguration>();
        if (this.fields != null && !this.fields.isEmpty()) {
            for (FieldRenameConfiguration fieldRenameConfig : this.fields) {
                if (Strings.isNullOrEmpty((String)fieldRenameConfig.getField())) {
                    context.buildConstraintViolationWithTemplate("The field name must be specified").addPropertyNode("FieldRename.field").addConstraintViolation();
                    return false;
                }
                if (Strings.isNullOrEmpty((String)fieldRenameConfig.getAlias())) {
                    context.buildConstraintViolationWithTemplate("New field Name should be specified").addPropertyNode("FieldRename.alias").addConstraintViolation();
                    return false;
                }
                if (!fieldRenameConfig.getAlias().equalsIgnoreCase("message")) continue;
                fieldRenameConfiguration.add(fieldRenameConfig);
                log.info("Removing FieldRenameConfiguration [{}] because it's trying to rename the message field which is not allowed", (Object)fieldRenameConfig);
            }
            for (FieldRenameConfiguration fieldRenameConfig : fieldRenameConfiguration) {
                this.fields.remove(fieldRenameConfig);
            }
        }
        return true;
    }

    @Generated
    public FieldRenameStageConfiguration() {
    }

    @Generated
    public List<FieldRenameConfiguration> getFields() {
        return this.fields;
    }

    @Generated
    public void setFields(List<FieldRenameConfiguration> fields) {
        this.fields = fields;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldRenameStageConfiguration)) {
            return false;
        }
        FieldRenameStageConfiguration other = (FieldRenameStageConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<FieldRenameConfiguration> this$fields = this.getFields();
        List<FieldRenameConfiguration> other$fields = other.getFields();
        return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FieldRenameStageConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<FieldRenameConfiguration> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FieldRenameStageConfiguration(fields=" + String.valueOf(this.getFields()) + ")";
    }
}

