/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.field;

import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.util.AbstractPipelineStage;
import com.appdynamics.analytics.pipeline.xform.field.FieldRenameConfiguration;
import com.appdynamics.analytics.pipeline.xform.map.PositionalFieldInfo;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldRenameStage
extends AbstractPipelineStage<Map<String, Object>, Map<String, Object>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FieldRenameStage.class);
    private final List<FieldRenameConfiguration> fields;

    public FieldRenameStage(PipelineStageParameters<Map<String, Object>> parameters, List<FieldRenameConfiguration> fields) {
        super(parameters);
        this.fields = fields;
    }

    @Override
    public void process(Map<String, Object> input) {
        log.debug("The input to the Rename stage is [{}] ", input);
        this.renameField(input);
        this.invokeNext(input);
    }

    private void renameField(Map<String, Object> input) {
        if (this.fields != null && !this.fields.isEmpty()) {
            for (FieldRenameConfiguration fieldRenameConfiguration : this.fields) {
                String field = fieldRenameConfiguration.getField();
                String alias = fieldRenameConfiguration.getAlias();
                if (!input.containsKey(field)) continue;
                Object fieldValue = input.get(field);
                if (alias.equalsIgnoreCase("message")) continue;
                input.remove(field);
                if (fieldValue instanceof PositionalFieldInfo) {
                    PositionalFieldInfo fieldValue1 = (PositionalFieldInfo)fieldValue;
                    input.put(alias, new PositionalFieldInfo(fieldValue, fieldValue1.getStart(), fieldValue1.getEnd()));
                    continue;
                }
                input.put(alias, fieldValue);
            }
        }
    }
}

