/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.field;

import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.util.AbstractPipelineStage;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.checkerframework.checker.nullness.qual.Nullable;

class FieldRemovalStage
extends AbstractPipelineStage<Map<String, Object>, Map<String, Object>> {
    private final List<String> removeFields;
    private static final Set<String> MANDATORY_FIELDS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER){
        {
            this.add("message");
            this.add("host");
            this.add("source");
            this.add("sourceType");
        }
    };

    FieldRemovalStage(PipelineStageParameters<Map<String, Object>> parameters, List<String> fieldKeys) {
        super(parameters);
        this.removeFields = ImmutableList.builder().addAll(Iterables.filter(fieldKeys, (Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                return !MANDATORY_FIELDS.contains(input);
            }
        })).build();
    }

    @Override
    public void process(Map<String, Object> input) {
        for (String fieldKey : this.removeFields) {
            input.remove(fieldKey);
        }
        this.invokeNext(input);
    }
}

