/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.field;

import com.appdynamics.analytics.pipeline.xform.field.FieldMaskingConfiguration;
import com.appdynamics.common.util.configuration.ManualValidateable;
import com.appdynamics.common.util.configuration.ManualValidated;
import com.google.common.base.Strings;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

@ManualValidated
public class FieldMaskingStageConfiguration
implements ManualValidateable {
    @NotNull
    List<FieldMaskingConfiguration> maskFields = new ArrayList<FieldMaskingConfiguration>();

    public boolean validate(ConstraintValidatorContext context) {
        if (this.maskFields != null && !this.maskFields.isEmpty()) {
            for (FieldMaskingConfiguration fm : this.maskFields) {
                if (Strings.isNullOrEmpty((String)fm.getField())) {
                    context.buildConstraintViolationWithTemplate("The field name must be specified").addPropertyNode("FieldMasking.field").addConstraintViolation();
                    return false;
                }
                if (fm.getStartIndex() <= fm.getEndIndex()) continue;
                context.buildConstraintViolationWithTemplate("The start Index must be smaller than end Index").addPropertyNode("FieldMasking.startIndex|FieldMasking.endIndex").addConstraintViolation();
                return false;
            }
        }
        return true;
    }

    @Generated
    public FieldMaskingStageConfiguration() {
    }

    @Generated
    public List<FieldMaskingConfiguration> getMaskFields() {
        return this.maskFields;
    }

    @Generated
    public void setMaskFields(List<FieldMaskingConfiguration> maskFields) {
        this.maskFields = maskFields;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldMaskingStageConfiguration)) {
            return false;
        }
        FieldMaskingStageConfiguration other = (FieldMaskingStageConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<FieldMaskingConfiguration> this$maskFields = this.getMaskFields();
        List<FieldMaskingConfiguration> other$maskFields = other.getMaskFields();
        return !(this$maskFields == null ? other$maskFields != null : !((Object)this$maskFields).equals(other$maskFields));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FieldMaskingStageConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<FieldMaskingConfiguration> $maskFields = this.getMaskFields();
        result = result * 59 + ($maskFields == null ? 43 : ((Object)$maskFields).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FieldMaskingStageConfiguration(maskFields=" + String.valueOf(this.getMaskFields()) + ")";
    }
}

