/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.field;

import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.util.AbstractPipelineStage;
import com.appdynamics.analytics.pipeline.xform.field.FieldMaskingConfiguration;
import com.appdynamics.analytics.pipeline.xform.field.MaskingType;
import com.appdynamics.analytics.pipeline.xform.map.PositionalFieldInfo;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldMaskingStage
extends AbstractPipelineStage<Map<String, Object>, Map<String, Object>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FieldMaskingStage.class);
    private static final Comparator<MaskingInfo> MASKING_INFO_COMPARATOR = new Comparator<MaskingInfo>(){

        @Override
        public int compare(MaskingInfo a1, MaskingInfo a2) {
            return a1.getStartIndex() - a2.getStartIndex();
        }
    };
    private final List<FieldMaskingConfiguration> maskFields;
    private final String source = "message";

    protected FieldMaskingStage(PipelineStageParameters<Map<String, Object>> parameters, List<FieldMaskingConfiguration> fields) {
        super(parameters);
        this.maskFields = fields;
    }

    @Override
    public void process(Map<String, Object> input) {
        ArrayList<MaskingInfo> maskingInfoList = new ArrayList<MaskingInfo>();
        for (FieldMaskingConfiguration maskingConfig : this.maskFields) {
            Object value;
            String field = maskingConfig.getField();
            if (!input.containsKey(field) || !((value = input.get(field)) instanceof PositionalFieldInfo)) continue;
            PositionalFieldInfo fieldValue = (PositionalFieldInfo)value;
            MaskingInfo maskingInfo = this.getMaskingInfoForField(input, fieldValue, maskingConfig);
            maskingInfoList.add(maskingInfo);
        }
        Collections.sort(maskingInfoList, MASKING_INFO_COMPARATOR);
        this.maskMessageField(maskingInfoList, input);
        this.invokeNext(input);
    }

    private MaskingInfo getMaskingInfoForField(Map<String, Object> input, PositionalFieldInfo fieldValue, FieldMaskingConfiguration maskingConfig) {
        String field = maskingConfig.getField();
        MaskingType maskType = maskingConfig.getMaskType();
        String replaceString = maskingConfig.getReplaceString();
        String value = fieldValue.getFieldValue().toString();
        int valueStartIndex = fieldValue.getStart();
        int valueEndIndex = fieldValue.getEnd();
        int messageStartIndex = 0;
        int messageEndIndex = 0;
        String replacementString = replaceString;
        switch (maskType) {
            case REPEAT: {
                int startIndex = maskingConfig.getStartIndex() - 1;
                int endIndex = this.getEndIndex(value, maskingConfig);
                int maskLength = endIndex - startIndex;
                int endAtIndex = startIndex + maskLength;
                replacementString = this.getRepeatingPattern(replaceString, maskLength);
                String maskedString = StringUtils.join((Object[])new String[]{StringUtils.substring((String)value, (int)0, (int)startIndex), replacementString, StringUtils.substring((String)value, (int)endAtIndex)});
                input.put(field, new PositionalFieldInfo(maskedString, messageStartIndex, messageEndIndex));
                messageStartIndex = valueStartIndex + startIndex;
                messageEndIndex = valueStartIndex + endAtIndex;
                break;
            }
            case REPLACE: {
                if (replaceString != null) {
                    input.put(field, new PositionalFieldInfo(replaceString));
                }
                messageStartIndex = valueStartIndex;
                messageEndIndex = valueEndIndex;
                break;
            }
            default: {
                log.error("Unsupported masking type.");
            }
        }
        return new MaskingInfo(messageStartIndex, messageEndIndex, replacementString);
    }

    public void maskMessageField(List<MaskingInfo> maskingInfoList, Map<String, Object> input) {
        Object value = input.get("message");
        if (value != null) {
            String message = value.toString();
            StringBuilder maskedMessage = new StringBuilder();
            int startIndex = 0;
            for (MaskingInfo maskingInfo : maskingInfoList) {
                if (maskingInfo.getStartIndex() > startIndex) {
                    maskedMessage.append(message.substring(startIndex, maskingInfo.getStartIndex()));
                }
                if (maskingInfo.getStartIndex() < message.length() && maskingInfo.getStartIndex() != maskingInfo.getEndIndex()) {
                    maskedMessage.append(maskingInfo.getMaskingPattern());
                }
                startIndex = maskingInfo.getEndIndex();
            }
            if (startIndex < message.length()) {
                maskedMessage.append(message.substring(startIndex));
            }
            input.put("message", new PositionalFieldInfo(maskedMessage.toString(), 0, maskedMessage.length()));
        }
    }

    private String getRepeatingPattern(String replaceString, int maskLength) {
        int numRepeatPattern = maskLength / replaceString.length();
        int remainingChar = maskLength - numRepeatPattern * replaceString.length();
        return StringUtils.join((Object[])new String[]{StringUtils.repeat((String)replaceString, (int)numRepeatPattern), StringUtils.left((String)replaceString, (int)remainingChar)});
    }

    private int getEndIndex(String value, FieldMaskingConfiguration maskingConfig) {
        int valueLength;
        int endIndex = maskingConfig.getEndIndex();
        if (endIndex > (valueLength = value.length())) {
            endIndex = valueLength;
        }
        return endIndex;
    }

    public static class MaskingInfo {
        private int startIndex;
        private int endIndex;
        private String maskingPattern;

        @ConstructorProperties(value={"startIndex", "endIndex", "maskingPattern"})
        @Generated
        public MaskingInfo(int startIndex, int endIndex, String maskingPattern) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.maskingPattern = maskingPattern;
        }

        @Generated
        public int getStartIndex() {
            return this.startIndex;
        }

        @Generated
        public int getEndIndex() {
            return this.endIndex;
        }

        @Generated
        public String getMaskingPattern() {
            return this.maskingPattern;
        }

        @Generated
        public void setStartIndex(int startIndex) {
            this.startIndex = startIndex;
        }

        @Generated
        public void setEndIndex(int endIndex) {
            this.endIndex = endIndex;
        }

        @Generated
        public void setMaskingPattern(String maskingPattern) {
            this.maskingPattern = maskingPattern;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MaskingInfo)) {
                return false;
            }
            MaskingInfo other = (MaskingInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStartIndex() != other.getStartIndex()) {
                return false;
            }
            if (this.getEndIndex() != other.getEndIndex()) {
                return false;
            }
            String this$maskingPattern = this.getMaskingPattern();
            String other$maskingPattern = other.getMaskingPattern();
            return !(this$maskingPattern == null ? other$maskingPattern != null : !this$maskingPattern.equals(other$maskingPattern));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MaskingInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStartIndex();
            result = result * 59 + this.getEndIndex();
            String $maskingPattern = this.getMaskingPattern();
            result = result * 59 + ($maskingPattern == null ? 43 : $maskingPattern.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FieldMaskingStage.MaskingInfo(startIndex=" + this.getStartIndex() + ", endIndex=" + this.getEndIndex() + ", maskingPattern=" + this.getMaskingPattern() + ")";
        }
    }
}

