/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.framework;

import com.appdynamics.analytics.pipeline.api.PipelineStageFactory;
import com.appdynamics.analytics.pipeline.framework.Pipelines;
import com.appdynamics.analytics.pipeline.framework.PipelinesHealthCheck;
import com.appdynamics.analytics.pipeline.framework.PipelinesModuleConfiguration;
import com.appdynamics.analytics.pipeline.framework.PipelinesResource;
import com.appdynamics.common.framework.util.Module;
import com.appdynamics.common.util.health.ConsolidatedHealthCheck;
import com.appdynamics.common.util.health.HealthCheckable;
import com.appdynamics.common.util.lifecycle.LifecycleInjector;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.dropwizard.core.setup.Environment;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelinesModule
extends Module<PipelinesModuleConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelinesModule.class);

    @Provides
    @Singleton
    Pipelines makePipelines(LifecycleInjector lifecycleInjector, Map<String, PipelineStageFactory> pipelineStageFactories) {
        return (Pipelines)((Object)lifecycleInjector.inject((Object)new Pipelines(pipelineStageFactories, ((PipelinesModuleConfiguration)this.getConfiguration()).getPipelines())));
    }

    @Inject
    void onStart(Environment environment, ConsolidatedHealthCheck healthCheck, Pipelines pipelines) {
        PipelinesModuleConfiguration configuration = (PipelinesModuleConfiguration)this.getConfiguration();
        PipelinesResource resource = new PipelinesResource(pipelines, configuration.isAuthenticate(), configuration.getAccountName(), configuration.getAccessKey());
        environment.jersey().register((Object)resource);
        if (((PipelinesModuleConfiguration)this.getConfiguration()).isReportPipelineInstancesHealth()) {
            PipelinesHealthCheck pipelinesHealthCheck = new PipelinesHealthCheck(this.getUri(), pipelines);
            healthCheck.register((HealthCheckable)pipelinesHealthCheck);
        } else {
            log.debug("Skipping pipeline instance health check");
        }
    }
}

