/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.framework;

import com.appdynamics.analytics.pipeline.api.PipelineStage;
import com.appdynamics.analytics.pipeline.framework.Pipeline;
import com.appdynamics.analytics.pipeline.framework.Pipelines;
import com.appdynamics.common.util.execution.Countable;
import com.appdynamics.common.util.health.SimpleHealthCheck;
import com.codahale.metrics.health.HealthCheck;
import java.util.TreeSet;

public class PipelinesHealthCheck
extends SimpleHealthCheck {
    private final Pipelines pipelines;

    PipelinesHealthCheck(String name, Pipelines pipelines) {
        super(name);
        this.pipelines = pipelines;
    }

    public HealthCheck.Result check() {
        if (this.pipelines.size() == 0) {
            return HealthCheck.Result.unhealthy((String)"Pipelines are not present");
        }
        int numNotRunning = 0;
        int numTotal = 0;
        TreeSet<Object> notRunningNames = new TreeSet<Object>();
        StringBuilder pipelineStageDetails = new StringBuilder();
        for (Pipeline pipeline : this.pipelines.getAll()) {
            Pipeline.State state = pipeline.getState();
            if (PipelinesHealthCheck.isUnhealthy(state)) {
                ++numNotRunning;
                notRunningNames.add(pipeline.getId());
            }
            if (numTotal > 0) {
                pipelineStageDetails.append(",    ");
            }
            PipelinesHealthCheck.printStatus(pipeline, pipelineStageDetails);
            ++numTotal;
        }
        if (numNotRunning == 0) {
            return HealthCheck.Result.healthy((String)String.format("[%d] pipeline(s). %s", numTotal, pipelineStageDetails));
        }
        return HealthCheck.Result.unhealthy((String)String.format("[%d] out of [%d] pipeline(s) are not running %s. %s", numNotRunning, numTotal, notRunningNames, pipelineStageDetails));
    }

    public static void printStatus(Pipeline<?> pipeline, StringBuilder destination) {
        int i = 0;
        destination.append(pipeline.getId()).append(": ");
        destination.append('[');
        for (PipelineStage pipelineStage : pipeline.getPipelineStages()) {
            if (i > 0) {
                destination.append(", ");
            }
            destination.append(pipelineStage.getClass().getSimpleName()).append(": ");
            if (pipelineStage instanceof Countable) {
                long count = ((Countable)pipelineStage).getCount();
                destination.append(count);
            } else {
                destination.append("N/A");
            }
            ++i;
        }
        destination.append(']');
    }

    private static boolean isUnhealthy(Pipeline.State state) {
        return state == Pipeline.State.IDLE || state == Pipeline.State.STOPPED;
    }
}

