/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.framework;

import com.appdynamics.analytics.pipeline.api.PipelineStage;
import com.appdynamics.analytics.pipeline.api.PipelineStageFactory;
import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.framework.Pipeline;
import com.appdynamics.analytics.pipeline.framework.PipelineConfiguration;
import com.appdynamics.analytics.pipeline.framework.PipelineStageConfiguration;
import com.appdynamics.analytics.pipeline.framework.StaticPipelineConfiguration;
import com.appdynamics.analytics.pipeline.util.PipelineHelper;
import com.appdynamics.common.util.concurrent.ConcurrencyHelper;
import com.appdynamics.common.util.configuration.ConfigurationException;
import com.appdynamics.common.util.item.Items;
import com.appdynamics.common.util.lifecycle.LifecycleAware;
import com.appdynamics.common.util.lifecycle.LifecycleHelper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pipelines
extends Items<Object, Pipeline<?>>
implements LifecycleAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Pipelines.class);
    final Map<String, PipelineStageFactory> pipelineStageFactories;
    final List<StaticPipelineConfiguration> optStaticPipelineConfigurations;
    private final ExecutorService pipelineExecutorService;

    public Pipelines(Map<String, PipelineStageFactory> pipelineStageFactories, List<StaticPipelineConfiguration> optStaticPipelineConfigurations) {
        super("Pipeline");
        this.pipelineStageFactories = pipelineStageFactories;
        this.optStaticPipelineConfigurations = optStaticPipelineConfigurations;
        log.debug("Loaded pipeline stage factories [\n  - {}\n]", (Object)Joiner.on((String)"\n  - ").join(pipelineStageFactories.values()));
        this.pipelineExecutorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("pipeline-thread-%d").setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                log.error("Unexpected error occurred on thread [" + t.getName() + "]", e);
            }
        }).build());
    }

    public Pipeline createPipeline(PipelineConfiguration pipelineConfiguration) {
        return Pipelines.createPipeline(pipelineConfiguration, this.pipelineStageFactories);
    }

    public static Pipeline createPipeline(PipelineConfiguration pipelineConfiguration, Map<String, PipelineStageFactory> pipelineStageFactories) {
        Preconditions.checkArgument((boolean)pipelineConfiguration.isEnabled(), (Object)"Pipeline could not be created as the configuration indicates that it is not enabled");
        List<PipelineStageConfiguration> scList = pipelineConfiguration.getStages();
        PipelineStageConfiguration[] stageConfigurations = scList.toArray(new PipelineStageConfiguration[scList.size()]);
        PipelineStage[] stages = new PipelineStage[stageConfigurations.length];
        Object pipelineId = pipelineConfiguration.getId();
        PipelineStage nextStage = null;
        for (int i = stageConfigurations.length - 1; i >= 0; --i) {
            String uri = stageConfigurations[i].getUri();
            PipelineStageFactory pc = pipelineStageFactories.get(uri);
            if (pc == null) {
                throw new ConfigurationException("No pipeline stage could be found for URI [" + uri + "]");
            }
            try {
                Map<String, Object> properties = stageConfigurations[i].getProperties();
                PipelineStageParameters stageParams = PipelineHelper.parameters(pipelineId, nextStage, properties);
                stages[i] = pc.create(stageParams);
                if (stages[i] == null) {
                    throw new NullPointerException("Pipeline stage created by factory [" + uri + "] is null");
                }
            }
            catch (RuntimeException e) {
                throw new ConfigurationException("Error occurred while configuring pipeline stage [" + uri + "]", (Throwable)e);
            }
            nextStage = stages[i];
        }
        return new Pipeline(pipelineId, stages);
    }

    final Future<Void> executePipeline(Pipeline pipeline) {
        return this.pipelineExecutorService.submit(Pipelines.wrapCallable(pipeline, null));
    }

    private static Callable<Void> wrapCallable(final Pipeline pipeline, final Object input) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    pipeline.call(input);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Error occurred while processing pipeline [" + String.valueOf(pipeline.getId()) + "]", t);
                }
                return null;
            }
        };
    }

    public final void start() {
        if (this.optStaticPipelineConfigurations != null && this.optStaticPipelineConfigurations.size() > 0) {
            log.debug("Attempting to load [{}] statically defined pipelines", (Object)this.optStaticPipelineConfigurations.size());
            for (StaticPipelineConfiguration pipelineConfiguration : this.optStaticPipelineConfigurations) {
                this.createAddStartAndExecuteIfEnabled(pipelineConfiguration);
            }
        } else {
            log.debug("No static pipelines have been defined");
        }
    }

    public final List<String> createAddStartAndExecuteIfEnabled(StaticPipelineConfiguration pipelineConfiguration) {
        if (!pipelineConfiguration.isEnabled()) {
            log.info("Ignored statically defined but disabled pipeline [{}]", pipelineConfiguration.getId());
            return Collections.emptyList();
        }
        int instances = pipelineConfiguration.getInstances();
        String originalPipelineId = String.valueOf(pipelineConfiguration.getId());
        ArrayList<String> pipelineIds = instances > 0 ? new ArrayList<String>(instances) : Collections.emptyList();
        for (int i = 0; i < instances; ++i) {
            Object newPipelineId = originalPipelineId;
            if (instances > 1) {
                newPipelineId = originalPipelineId + "-" + i;
            }
            Pipeline pipeline = (Pipeline)this.get(newPipelineId);
            pipelineIds.add((String)newPipelineId);
            if (pipeline == null) {
                pipelineConfiguration.setId(newPipelineId);
                this.createAddStartAndExecute(pipelineConfiguration);
                log.info("Loaded and started statically defined pipeline [{}]", newPipelineId);
                continue;
            }
            if (pipeline.getState() != Pipeline.State.CREATED) continue;
            pipeline.start();
            log.info("Started previously created pipeline [{}]", newPipelineId);
        }
        return pipelineIds;
    }

    public final Pipeline createAddAndStart(PipelineConfiguration pipelineConfiguration) {
        Pipeline pipeline = this.createPipeline(pipelineConfiguration);
        this.add(pipeline);
        pipeline.start();
        return pipeline;
    }

    public final Future<Void> createAddStartAndExecute(PipelineConfiguration pipelineConfiguration) {
        Pipeline pipeline = this.createAddAndStart(pipelineConfiguration);
        return this.executePipeline(pipeline);
    }

    public final void stop() {
        Collection all = this.getAll();
        if (all.size() > 0) {
            log.info("Attempting to stop pipelines");
            LifecycleHelper.stopAll((Iterable)all);
        }
        ConcurrencyHelper.stop((ExecutorService)this.pipelineExecutorService, (Logger)log);
        log.info("Pipelines have stopped");
    }
}

