/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.message.util;

import com.appdynamics.analytics.message.api.MessagePack;
import com.appdynamics.common.util.execution.Retriable;
import java.util.ArrayDeque;
import java.util.Deque;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetriableMessagePack<SRC_ID, MSG>
implements MessagePack<SRC_ID, MSG>,
Retriable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetriableMessagePack.class);
    private final SRC_ID srcId;
    private final Deque<MSG> messages;
    private final Deque<ReturnedMessage<MSG>> undeliveredErrorMessages;
    private final Deque<MSG> undeliveredMessages;
    private int deliveryAttempt;

    public RetriableMessagePack(SRC_ID srcId) {
        this(srcId, new ArrayDeque(), new ArrayDeque<ReturnedMessage<MSG>>());
    }

    public RetriableMessagePack(SRC_ID srcId, Deque<MSG> messages) {
        this(srcId, messages, new ArrayDeque<ReturnedMessage<MSG>>());
    }

    public RetriableMessagePack(SRC_ID srcId, Deque<MSG> messages, Deque<ReturnedMessage<MSG>> undeliveredErrorMessages) {
        this.srcId = srcId;
        this.messages = messages;
        this.undeliveredErrorMessages = undeliveredErrorMessages;
        this.undeliveredMessages = new ArrayDeque<MSG>();
    }

    @Override
    public final SRC_ID getSourceId() {
        return this.srcId;
    }

    @Override
    public final int size() {
        return this.messages.size();
    }

    @Override
    public final MSG peek() {
        return this.messages.peek();
    }

    @Override
    public final MSG poll() {
        return this.messages.poll();
    }

    @Override
    public final void returnUndelivered(MSG undeliverableMsg) {
        boolean ok;
        if (log.isTraceEnabled()) {
            log.trace("Message in the pack from source [{}] has been returned as undelivered [{}]", this.srcId, undeliverableMsg);
        }
        if (!(ok = this.undeliveredMessages.offer(undeliverableMsg))) {
            log.warn("Queue appears to be full. Unable to store undelivered message [{}]", undeliverableMsg);
        }
    }

    @Override
    public final void returnUndelivered(MSG undeliverableMsg, Throwable cause) {
        boolean ok;
        if (log.isTraceEnabled()) {
            log.trace("Message in the pack from source [" + String.valueOf(this.srcId) + "] has been returned as undeliverable due to error [" + String.valueOf(undeliverableMsg) + "]", cause);
        }
        if (!(ok = this.undeliveredErrorMessages.offer(new ReturnedMessage<MSG>(undeliverableMsg, cause)))) {
            log.warn("Queue appears to be full. Unable to store undelivered message [{}]", undeliverableMsg);
        }
    }

    public final void resetCounts() {
        this.deliveryAttempt = 0;
    }

    public final boolean offer(MSG msg) {
        return this.messages.offer(msg);
    }

    public final void clear() {
        this.messages.clear();
    }

    protected final Deque<MSG> getMessages() {
        return this.messages;
    }

    public final Deque<ReturnedMessage<MSG>> getUndeliveredErrorMessages() {
        return this.undeliveredErrorMessages;
    }

    public final int getAttempt() {
        return this.deliveryAttempt;
    }

    public final int incAttempt() {
        return ++this.deliveryAttempt;
    }

    private void recirculateUndelivered() {
        Object msg = null;
        while (true) {
            MSG MSG = this.undeliveredMessages.poll();
            msg = MSG;
            if (MSG == null) break;
            boolean doIt = this.beforeRecirculate(msg);
            if (!doIt) continue;
            if (log.isTraceEnabled()) {
                log.trace("Recirculating message [{}] in pack from source [{}]", msg, this.srcId);
            }
            this.messages.offer(msg);
        }
    }

    protected boolean beforeRecirculate(MSG msg) {
        return true;
    }

    public final boolean done() {
        this.recirculateUndelivered();
        return this.onAttemptEnd();
    }

    protected boolean onAttemptEnd() {
        return this.size() > 0;
    }

    public final void done(Throwable cause) {
        this.recirculateUndelivered();
        this.onAttemptEnd(cause);
    }

    protected void onAttemptEnd(Throwable cause) {
        if (log.isTraceEnabled()) {
            log.trace("Delivery attempt of message pack from source [" + String.valueOf(this.srcId) + "] ended in error", cause);
        }
    }

    public static class ReturnedMessage<MSG> {
        private final MSG message;
        private final Throwable cause;

        public ReturnedMessage(MSG message, Throwable cause) {
            this.message = message;
            this.cause = cause;
        }

        public MSG getMessage() {
            return this.message;
        }

        public Throwable getCause() {
            return this.cause;
        }
    }
}

