/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.message;

import com.appdynamics.analytics.message.api.MessageSource;
import com.appdynamics.common.util.configuration.CommonReader;
import com.appdynamics.common.util.misc.ParameterAwareSupplier;
import com.google.common.base.Supplier;
import com.google.common.reflect.TypeToken;
import com.google.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;

@Singleton
public class MessageSources {
    private final Map<Object, Supplier<? extends MessageSource<?, ?>>> registry = new ConcurrentHashMap();

    MessageSources() {
    }

    public void register(Object srcId, Supplier<? extends MessageSource<?, ?>> messageSourceSupplier) {
        this.registry.put(srcId, messageSourceSupplier);
    }

    public void register(Object srcId, ParameterAwareSupplier<?, ? extends MessageSource<?, ?>> messageSourceSupplier) {
        this.registry.put(srcId, (Supplier<MessageSource<?, ?>>)messageSourceSupplier);
    }

    public Supplier<? extends MessageSource<?, ?>> getSupplier(Object srcId) {
        return this.registry.get(srcId);
    }

    public MessageSource<?, ?> get(Object srcId) {
        Supplier<? extends MessageSource<?, ?>> supplier = this.getSupplier(srcId);
        return supplier != null ? (MessageSource)supplier.get() : null;
    }

    public MessageSource<?, ?> get(Object srcId, Object additionalParam) {
        Supplier<MessageSource<?, ?>> supplier = this.getSupplier(srcId);
        if (supplier == null) {
            return null;
        }
        if (supplier instanceof ParameterAwareSupplier) {
            ParameterAwareSupplier pas = (ParameterAwareSupplier)supplier;
            Object convertedParam = null;
            try {
                TypeToken parameterTypeToken = ParameterAwareSupplier.Helper.findParameterType((ParameterAwareSupplier)pas);
                convertedParam = CommonReader.readFrom((TypeToken)parameterTypeToken, (Object)additionalParam);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("An error occurred while attempting to transform the parameter [" + String.valueOf(additionalParam) + "] of type [" + additionalParam.getClass().getName() + "] to the type required by [" + pas.getClass().getName() + "]");
            }
            return (MessageSource)pas.get(convertedParam);
        }
        throw new UnsupportedOperationException("The supplier [" + supplier.getClass().getName() + "] is not an instance of [" + ParameterAwareSupplier.class.getName() + "]");
    }

    public Supplier<? extends MessageSource<?, ?>> unregister(Object srcId) {
        return this.registry.remove(srcId);
    }

    @PreDestroy
    public void removeAll() {
        this.registry.clear();
    }
}

