/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.grok;

import com.appdynamics.analytics.pipeline.xform.grok.GrokUtils;
import com.appdynamics.common.framework.util.Module;
import com.appdynamics.common.io.IoHelper;
import com.appdynamics.common.io.file.FilePathConfiguration;
import com.appdynamics.common.util.grok.Grok;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrokLoaderFactory
extends Module<FilePathConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrokLoaderFactory.class);

    @Provides
    @Singleton
    public Grok makeGrok() {
        Grok newGrok = new Grok();
        List<InputStream> inputStreams = GrokUtils.getGrokFromResourcesSection();
        try {
            String grokPath;
            newGrok.addFromInputStreams(inputStreams.toArray(new InputStream[inputStreams.size()]));
            FilePathConfiguration grokLocalPath = (FilePathConfiguration)this.getConfiguration();
            if (grokLocalPath != null && !StringUtils.isBlank((CharSequence)(grokPath = grokLocalPath.getPath()))) {
                Path path = Paths.get(grokPath, new String[0]);
                PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + grokLocalPath.getNameGlob());
                List grokFilePaths = IoHelper.findMatchingPaths((Path)path, (PathMatcher)pathMatcher);
                newGrok.addFromGrokFiles(grokFilePaths);
            }
            return newGrok;
        }
        catch (IOException e) {
            log.error("Error occurred while loading grok", (Throwable)e);
            return newGrok;
        }
    }
}

