/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.var;

import com.appdynamics.common.util.var.VariableResolver;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SystemVariableResolver implements VariableResolver
{
    INSTANCE;

    @Generated
    private static final Logger log;
    public static final String VAR_SYSTEM_PROCESS_ID = "system.process.id";
    public static final String VAR_SYSTEM_HOST_NAME = "system.host.name";
    public static final long HOST_NAME_CACHE_TIME_NANOS = 5000000000L;
    static final Long PROCESS_ID;
    static volatile String hostName;
    static volatile long hostNameResolvedAtNanos;

    @Override
    public Object resolve(String variable) {
        switch (variable) {
            case "system.process.id": {
                return PROCESS_ID;
            }
            case "system.host.name": {
                return SystemVariableResolver.getHostName();
            }
        }
        return null;
    }

    @Override
    public Object resolve(String variable, String variableExtension) {
        return null;
    }

    public static long getProcessId() {
        return PROCESS_ID;
    }

    public static String getHostName() {
        long timeNanos = System.nanoTime();
        if (hostName == null || timeNanos - hostNameResolvedAtNanos > 5000000000L) {
            try {
                InetAddress localHost = InetAddress.getLocalHost();
                String s = localHost.getCanonicalHostName();
                hostName = s = s.equals(localHost.getHostAddress()) ? localHost.getHostName() : s;
            }
            catch (UnknownHostException e) {
                hostName = "localhost";
            }
            hostNameResolvedAtNanos = timeNanos;
        }
        return hostName;
    }

    static {
        log = LoggerFactory.getLogger(SystemVariableResolver.class);
        String pidStr = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        long pid = 0L;
        try {
            pid = Long.parseLong(pidStr);
        }
        catch (NumberFormatException e) {
            log.warn("Process id could not be extracted", (Throwable)e);
        }
        PROCESS_ID = pid;
    }
}

