/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.var;

import com.appdynamics.common.util.var.VariableResolver;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum FileIncludeVariableResolver implements VariableResolver
{
    INSTANCE;

    @Generated
    private static final Logger log;
    public static final String VAR_INCLUDE = "include.file";

    @Override
    public Object resolve(String variable) {
        return null;
    }

    @Override
    public List<String> resolve(String variable, String variableExtension) {
        if (!variable.equals(VAR_INCLUDE)) {
            return null;
        }
        log.debug("Attempting to load file [{}]", (Object)variableExtension);
        File file = new File(variableExtension);
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("The path [" + variableExtension + "] does not point to a valid file");
        }
        try {
            return Files.readAllLines(file.toPath(), Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("An error occurred while reading lines from the file [" + variableExtension + "]", e);
        }
    }

    static {
        log = LoggerFactory.getLogger(FileIncludeVariableResolver.class);
    }
}

