/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.var;

import com.appdynamics.common.util.var.AbstractVariableResolver;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.text.WordUtils;

public class DottedKeyMapBasedVariableResolver
extends AbstractVariableResolver {
    final Map<String, ?> map;
    private boolean failIfNotResolved = false;

    public DottedKeyMapBasedVariableResolver(Map<String, ?> map) {
        this.map = map;
    }

    public DottedKeyMapBasedVariableResolver(Map<String, ?> map, boolean failIfNotResolved) {
        this.map = map;
        this.failIfNotResolved = failIfNotResolved;
    }

    @Override
    public Object resolve(String variable) {
        Object value = this.resolveInternal(variable);
        if (value == null && this.failIfNotResolved) {
            throw new IllegalArgumentException("Unable to resolve variable [" + variable + "]");
        }
        return value;
    }

    private Object resolveInternal(String variable) {
        String[] path = variable.split("\\.");
        if (path.length == 0) {
            return null;
        }
        Object value = this.map.get(path[0]);
        if (value == null) {
            return null;
        }
        return this.resolveFromPath(path, 1, value);
    }

    private Object resolveFromPath(String[] path, int offset, Object source) {
        if (offset == path.length) {
            return source;
        }
        if (source instanceof Map) {
            return this.resolveFromPath(path, offset + 1, ((Map)source).get(path[offset]));
        }
        String key = WordUtils.capitalize((String)path[offset]);
        try {
            Method m = source.getClass().getMethod("get" + key, new Class[0]);
            return m.invoke(source, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }
}

