/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.var;

import com.appdynamics.common.util.var.VariableResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ChainedVariableResolver
implements VariableResolver {
    final List<VariableResolver> resolverChain;

    public ChainedVariableResolver(VariableResolver resolver1, VariableResolver resolver2, VariableResolver ... remainingResolvers) {
        ArrayList<VariableResolver> chain = new ArrayList<VariableResolver>(remainingResolvers.length + 2);
        chain.add(resolver1);
        chain.add(resolver2);
        chain.addAll(Arrays.asList(remainingResolvers));
        this.resolverChain = chain;
    }

    @Override
    public Object resolve(String variable) {
        for (VariableResolver variableResolver : this.resolverChain) {
            Object o = variableResolver.resolve(variable);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    @Override
    public Object resolve(String variable, String variableExtension) {
        for (VariableResolver variableResolver : this.resolverChain) {
            Object o = variableResolver.resolve(variable, variableExtension);
            if (o == null) continue;
            return o;
        }
        return null;
    }
}

