/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.var;

import com.appdynamics.common.util.var.VariableResolver;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CalendarVariableResolver implements VariableResolver
{
    INSTANCE;

    @Generated
    private static final Logger log;
    public static final String VAR_NOW = "calendar.now";
    static final ConcurrentHashMap<String, DateTimeFormatter> DATE_TIME_FORMATS;

    @Override
    public Object resolve(String variable) {
        return null;
    }

    @Override
    public Object resolve(String variable, String variableExtension) {
        if (!variable.equals(VAR_NOW)) {
            return null;
        }
        DateTimeFormatter fmt = DATE_TIME_FORMATS.get(variableExtension);
        if (fmt == null) {
            try {
                fmt = DateTimeFormat.forPattern((String)variableExtension);
            }
            catch (IllegalArgumentException e) {
                log.error("Error occurred while parsing date time format [" + variableExtension + "]", (Throwable)e);
                return null;
            }
        }
        DATE_TIME_FORMATS.putIfAbsent(variableExtension, fmt);
        return DateTime.now().toString(fmt);
    }

    static {
        log = LoggerFactory.getLogger(CalendarVariableResolver.class);
        DATE_TIME_FORMATS = new ConcurrentHashMap();
    }
}

