/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.unit;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteSizes {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ByteSizes.class);
    private static final Pattern SIZE_PATTERN = Pattern.compile("\\s*([\\d.]+)\\s*([TGMK]B)", 2);
    private static final Map<String, Integer> SIZE_POWER_MAP = new HashMap<String, Integer>();

    public static long parseToBytes(String sizeStr) {
        if (sizeStr == null) {
            throw new IllegalArgumentException("Could not parse null into bytes.");
        }
        Matcher matcher = SIZE_PATTERN.matcher(sizeStr);
        if (!matcher.find() || matcher.groupCount() <= 1) {
            throw new IllegalArgumentException("Could not parse [" + sizeStr + "] into bytes.  Supported formats are [TB, GB, MB, KB]");
        }
        String number = matcher.group(1);
        int pow = SIZE_POWER_MAP.get(matcher.group(2).toUpperCase());
        BigDecimal bytes = new BigDecimal(number).multiply(BigDecimal.valueOf(1024L).pow(pow));
        long sizeBytes = bytes.longValue();
        log.debug("Parsed [{}] into [{}] bytes", (Object)sizeStr, (Object)sizeBytes);
        return sizeBytes;
    }

    static {
        SIZE_POWER_MAP.put("TB", 4);
        SIZE_POWER_MAP.put("GB", 3);
        SIZE_POWER_MAP.put("MB", 2);
        SIZE_POWER_MAP.put("KB", 1);
    }
}

