/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.regex;

import com.google.common.collect.ImmutableSortedMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class RegexHelper {
    private static Method cachedNamedGroupsGetter;

    private RegexHelper() {
    }

    private static Method namedGroupsGetter() throws NoSuchMethodException {
        if (cachedNamedGroupsGetter != null) {
            return cachedNamedGroupsGetter;
        }
        Method method = Pattern.class.getDeclaredMethod("namedGroups", new Class[0]);
        method.setAccessible(true);
        cachedNamedGroupsGetter = method;
        return cachedNamedGroupsGetter;
    }

    public static Map<String, Integer> namedGroups(Pattern pattern) {
        try {
            Method method = RegexHelper.namedGroupsGetter();
            Object o = method.invoke((Object)pattern, new Object[0]);
            Map mapOfGroupNames = (Map)o;
            return ImmutableSortedMap.copyOf((Map)mapOfGroupNames);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static String removePunctuations(String nonCompliantName) {
        return nonCompliantName.replaceAll("\\p{Punct}", "");
    }
}

