/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.locks;

import com.appdynamics.common.util.datetime.TimeUnitConfiguration;
import com.appdynamics.common.util.exception.TransientException;
import com.appdynamics.common.util.locks.ClusterLock;
import com.appdynamics.common.util.locks.InterProcessLock;
import com.appdynamics.common.util.locks.InterProcessLockFactory;
import com.appdynamics.common.util.locks.LockAcquisitionTimeoutException;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.concurrent.Callable;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterProcessClusterLock
implements ClusterLock {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InterProcessClusterLock.class);
    @NonNull
    private final InterProcessLockFactory lockFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> Optional<V> acquireAndExecute(String lockId, TimeUnitConfiguration timeout, Callable<V> callable) throws Exception {
        InterProcessLock lock = this.acquireLock(lockId, timeout);
        try {
            Optional<V> optional = Optional.ofNullable(callable.call());
            return optional;
        }
        finally {
            try {
                lock.release();
            }
            catch (Exception e) {
                log.warn("Failed to release lock.", (Throwable)e);
            }
        }
    }

    private InterProcessLock acquireLock(String lockId, TimeUnitConfiguration timeout) throws LockAcquisitionTimeoutException {
        boolean lockAcquired;
        InterProcessLock lock = this.lockFactory.getLock(lockId);
        try {
            lockAcquired = lock.acquire(timeout.getTime(), timeout.getTimeUnit());
        }
        catch (Exception e) {
            throw new TransientException(e);
        }
        if (!lockAcquired) {
            throw new LockAcquisitionTimeoutException(lockId, timeout);
        }
        return lock;
    }

    @ConstructorProperties(value={"lockFactory"})
    @Generated
    public InterProcessClusterLock(@NonNull InterProcessLockFactory lockFactory) {
        if (lockFactory == null) {
            throw new IllegalArgumentException("lockFactory is marked non-null but is null");
        }
        this.lockFactory = lockFactory;
    }
}

