/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.locks;

import com.appdynamics.common.util.concurrent.Callables;
import com.appdynamics.common.util.datetime.TimeUnitConfiguration;
import com.appdynamics.common.util.locks.ClusterLock;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterLockConditionalCallable<V>
implements Callable<Optional<V>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterLockConditionalCallable.class);
    @NonNull
    private final String lockId;
    @NonNull
    private final Callable<V> delegate;
    @NonNull
    private final ClusterLock clusterLock;
    @NonNull
    private final TimeUnitConfiguration lockAcquisitionTimeout;

    @Override
    public final Optional<V> call() throws Exception {
        try {
            return this.clusterLock.acquireAndExecute(this.lockId, this.lockAcquisitionTimeout, Callables.getMdcForwardingCallable(this.delegate));
        }
        catch (TimeoutException e) {
            log.debug("Timed out waiting for lock: lockId=[{}]", (Object)this.lockId, (Object)e);
            return Optional.empty();
        }
    }

    @ConstructorProperties(value={"lockId", "delegate", "clusterLock", "lockAcquisitionTimeout"})
    @Generated
    public ClusterLockConditionalCallable(@NonNull String lockId, @NonNull Callable<V> delegate, @NonNull ClusterLock clusterLock, @NonNull TimeUnitConfiguration lockAcquisitionTimeout) {
        if (lockId == null) {
            throw new IllegalArgumentException("lockId is marked non-null but is null");
        }
        if (delegate == null) {
            throw new IllegalArgumentException("delegate is marked non-null but is null");
        }
        if (clusterLock == null) {
            throw new IllegalArgumentException("clusterLock is marked non-null but is null");
        }
        if (lockAcquisitionTimeout == null) {
            throw new IllegalArgumentException("lockAcquisitionTimeout is marked non-null but is null");
        }
        this.lockId = lockId;
        this.delegate = delegate;
        this.clusterLock = clusterLock;
        this.lockAcquisitionTimeout = lockAcquisitionTimeout;
    }
}

