/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.lifecycle;

import com.appdynamics.common.util.lifecycle.LifecycleAware;
import java.util.LinkedList;

public abstract class LifecycleHelper {
    private LifecycleHelper() {
    }

    public static void startAll(Iterable<? extends LifecycleAware> iterable) {
        LinkedList<LifecycleAware> started = new LinkedList<LifecycleAware>();
        try {
            for (LifecycleAware lifecycleAware : iterable) {
                lifecycleAware.start();
                started.add(lifecycleAware);
            }
        }
        catch (Exception e) {
            for (LifecycleAware lifecycleAware : started) {
                try {
                    lifecycleAware.stop();
                }
                catch (Exception e1) {
                    e.addSuppressed(e1);
                }
            }
            throw e;
        }
        finally {
            started.clear();
        }
    }

    public static void stopAll(Iterable<? extends LifecycleAware> iterable) {
        for (LifecycleAware lifecycleAware : iterable) {
            lifecycleAware.stop();
        }
    }
}

