/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.json;

import com.appdynamics.common.util.json.DefaultFieldName;
import com.appdynamics.common.util.json.EmptyFieldName;
import com.appdynamics.common.util.json.FieldName;
import com.appdynamics.common.util.json.JsonObjectParsingException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.Stack;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectListParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ObjectListParser.class);
    protected final JsonFactory jsonFactory;
    protected final int payloadOffset;
    protected final int payloadLength;
    protected byte[] currentPayload;
    protected int rootObjectOffset;
    protected int rootObjectLength;
    protected JsonParser parser;
    protected ParserState state;
    protected Stack<JsonNode> objectStack = new Stack();
    protected ObjectMapper mapper = new ObjectMapper();

    protected ObjectListParser(byte[] payloads, int payloadOffset, int payloadLength) {
        Preconditions.checkNotNull((Object)payloads, (Object)"payloads can't be null");
        Preconditions.checkArgument((payloadOffset >= 0 ? 1 : 0) != 0, (Object)"payloadOffset must be greater than or equal to 0");
        Preconditions.checkArgument((payloadLength >= 0 ? 1 : 0) != 0, (Object)"payloadLength must be greater than or equal to 0");
        this.currentPayload = payloads;
        this.payloadOffset = payloadOffset;
        this.payloadLength = payloadLength;
        this.jsonFactory = new JsonFactory();
        this.reset();
    }

    public void reset() {
        this.state = ParserState.START;
        try {
            this.parser = this.jsonFactory.createParser(this.currentPayload, this.payloadOffset, this.payloadLength);
        }
        catch (IOException e) {
            throw new JsonObjectParsingException("Could not parse payload", e);
        }
    }

    public int getPayloadOffset() {
        return this.payloadOffset;
    }

    public int getPayloadLength() {
        return this.payloadLength;
    }

    public byte[] getPayloads() {
        return this.currentPayload;
    }

    public int getMeteredPayloadSize() {
        return this.payloadLength;
    }

    public boolean next() {
        int nestingLevel = 0;
        try {
            JsonToken token = this.parser.nextValue();
            while (token != null) {
                block1 : switch (this.state) {
                    case START: {
                        if (token != JsonToken.START_ARRAY) {
                            throw new JsonObjectParsingException("Expected an array of objects, got " + token.name());
                        }
                        this.state = ParserState.IN_ARRAY;
                        break;
                    }
                    case IN_ARRAY: {
                        if (token == JsonToken.START_OBJECT) {
                            this.rootObjectOffset = this.getStartOffset();
                            log.trace("Object start at {}", (Object)this.rootObjectOffset);
                            this.startObject(null, 0, this.rootObjectOffset);
                        } else if (token != JsonToken.END_ARRAY) {
                            throw new JsonObjectParsingException("Expected objects in array, got " + token.name());
                        }
                        this.state = ParserState.IN_OBJECT;
                        nestingLevel = 1;
                        break;
                    }
                    case IN_OBJECT: {
                        switch (token) {
                            case END_OBJECT: {
                                int end = this.getEndOffset();
                                this.endObject(--nestingLevel, end);
                                if (nestingLevel != 0) break block1;
                                log.trace("Object end at {}", (Object)end);
                                this.rootObjectLength = end - this.rootObjectOffset;
                                if (log.isTraceEnabled()) {
                                    String objStr = new String(this.currentPayload, this.rootObjectOffset, this.rootObjectLength, Charsets.UTF_8);
                                    log.trace("Found object {}", (Object)objStr);
                                }
                                this.objectStack.push(this.mapper.readTree(Arrays.copyOfRange(this.currentPayload, this.rootObjectOffset, this.rootObjectOffset + this.rootObjectLength)));
                                this.state = ParserState.IN_ARRAY;
                                return true;
                            }
                            case START_OBJECT: {
                                int start = this.getStartOffset();
                                this.startObject(this.currentName(), nestingLevel, start);
                                ++nestingLevel;
                                break;
                            }
                            case VALUE_FALSE: {
                                this.field(this.currentName(), false);
                                break;
                            }
                            case VALUE_TRUE: {
                                this.field(this.currentName(), true);
                                break;
                            }
                            case VALUE_NULL: {
                                this.nullValue(this.currentName());
                                break;
                            }
                            case VALUE_NUMBER_FLOAT: {
                                this.field(this.currentName(), this.parser.getDoubleValue());
                                break;
                            }
                            case VALUE_NUMBER_INT: {
                                this.field(this.currentName(), this.parser.getLongValue());
                                break;
                            }
                            case VALUE_STRING: {
                                this.field(this.currentName(), this.parser.getValueAsString());
                                break;
                            }
                        }
                        break;
                    }
                    default: {
                        log.warn("Bad parser state {}", (Object)this.state);
                        throw new RuntimeException("Bad parser state " + String.valueOf((Object)this.state));
                    }
                }
                token = this.parser.nextValue();
            }
        }
        catch (IOException e) {
            throw new JsonObjectParsingException("Exception occurred while parsing the JSON string", e);
        }
        return false;
    }

    protected FieldName currentName() throws IOException {
        String currentName = this.parser.getCurrentName();
        return currentName == null ? EmptyFieldName.getInstance() : DefaultFieldName.from(this.parser.getCurrentName());
    }

    public int getEndOffset() {
        return (int)this.parser.getCurrentLocation().getByteOffset() + this.payloadOffset;
    }

    public int getStartOffset() {
        return (int)(this.parser.getCurrentLocation().getByteOffset() - 1L + (long)this.payloadOffset);
    }

    protected int getCurrentOffset() {
        return (int)this.parser.getTokenLocation().getByteOffset();
    }

    protected void field(FieldName fieldName, String val) {
    }

    protected void field(FieldName fieldName, long val) {
    }

    protected void field(FieldName fieldName, double val) {
    }

    protected void nullValue(FieldName fieldName) {
    }

    protected void field(FieldName fieldName, boolean val) {
    }

    protected void startObject(FieldName fieldName, int nestingLevel, int offset) {
    }

    protected void endObject(int nestingLevel, int offset) {
    }

    public void parseAndCheckFormat() {
        while (this.next()) {
        }
        this.state = ParserState.END;
    }

    public boolean hasParsed() {
        return this.state == ParserState.END;
    }

    public JsonNode nextObject() {
        if (!this.next()) {
            return null;
        }
        return this.objectStack.pop();
    }

    public long getCurrentNumberOfPayloads() {
        return this.objectStack.size();
    }

    @Generated
    public int getRootObjectOffset() {
        return this.rootObjectOffset;
    }

    @Generated
    public int getRootObjectLength() {
        return this.rootObjectLength;
    }

    private static enum ParserState {
        START,
        IN_ARRAY,
        IN_OBJECT,
        END;

    }

    public static class Factory {
        public ObjectListParser make(byte[] payloads, int payloadOffset, int payloadLength) {
            return new ObjectListParser(payloads, payloadOffset, payloadLength);
        }
    }
}

