/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Map;
import lombok.Generated;

public final class JsonUtils {
    public static void mergeOrCopyObjectIfNotPresent(JsonNode existing, ObjectNode updated, String fieldName) {
        Optional<ObjectNode> objectNode = JsonUtils.getObjectNode((JsonNode)updated, fieldName);
        if (!objectNode.isPresent()) {
            updated.set(fieldName, existing.get(fieldName));
        } else {
            Optional<ObjectNode> existingObjectNode = JsonUtils.getObjectNode(existing, fieldName);
            if (existingObjectNode.isPresent()) {
                Iterator iter = ((ObjectNode)existingObjectNode.get()).fields();
                while (iter.hasNext()) {
                    Map.Entry node = (Map.Entry)iter.next();
                    if (((ObjectNode)objectNode.get()).get((String)node.getKey()) != null) continue;
                    ((ObjectNode)objectNode.get()).set((String)node.getKey(), ((JsonNode)node.getValue()).deepCopy());
                }
            }
        }
    }

    private static Optional<ObjectNode> getObjectNode(JsonNode node, String fieldName) {
        JsonNode nodeToFetch = node.get(fieldName);
        if (nodeToFetch == null || nodeToFetch.isNull()) {
            return Optional.absent();
        }
        Preconditions.checkState((boolean)nodeToFetch.isObject(), (String)"Expected node [%s] to be an ObjectNode", (Object)fieldName);
        return Optional.of((Object)((ObjectNode)nodeToFetch));
    }

    public static void copyField(String fieldName, ObjectNode from, ObjectNode to) {
        JsonNode fromNode = from.get(fieldName);
        Preconditions.checkArgument((fromNode != null && !fromNode.isNull() ? 1 : 0) != 0, (String)"Expected to find field [%s] in from node", (Object)fieldName);
        to.setAll((Map)ImmutableMap.of((Object)fieldName, (Object)fromNode.deepCopy()));
    }

    @Generated
    private JsonUtils() {
    }
}

