/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.item;

import com.appdynamics.common.util.exception.ItemNotPresentException;
import com.appdynamics.common.util.exception.ItemPresentException;
import com.appdynamics.common.util.item.Item;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class Items<ID, X extends Item<? extends ID>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Items.class);
    protected final String itemNickName;
    protected final ConcurrentMap<ID, X> items;

    public Items(String itemNickName) {
        this.itemNickName = itemNickName;
        this.items = new ConcurrentHashMap<ID, X>();
    }

    public Collection<ID> getIds() {
        return ImmutableList.copyOf(this.items.keySet());
    }

    public X get(ID itemId) {
        return (X)((Item)this.items.get(itemId));
    }

    public Collection<? extends X> getAll() {
        return ImmutableList.copyOf(this.items.values());
    }

    public int size() {
        return this.items.size();
    }

    public void add(X item) {
        Item old = (Item)this.items.putIfAbsent(item.getId(), item);
        if (old != null) {
            throw new ItemPresentException(this.itemNickName + " id [" + String.valueOf(item.getId()) + "] already exists");
        }
    }

    public X upsert(X item) {
        Item old = (Item)this.items.put(item.getId(), item);
        if (old == null) {
            log.warn(this.itemNickName + " id [" + String.valueOf(item.getId()) + "] did not exist");
        }
        return (X)old;
    }

    public X remove(ID itemId) {
        Item x = (Item)this.items.remove(itemId);
        if (x == null) {
            throw new ItemNotPresentException(this.itemNickName + " id [" + String.valueOf(itemId) + "] does not exist");
        }
        return (X)x;
    }

    public void removeInstance(X instance) {
        boolean removed = this.items.remove(instance.getId(), instance);
        if (!removed) {
            throw new ItemNotPresentException(this.itemNickName + " id [" + String.valueOf(instance.getId()) + "] does not exist");
        }
    }

    protected void removeAll() {
        LinkedList<X> list = new LinkedList<X>(this.getAll());
        for (Item item : list) {
            this.removeInstance(item);
        }
        list.clear();
    }

    public boolean contains(ID itemId) {
        return this.items.containsKey(itemId);
    }
}

