/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.execution;

import com.appdynamics.common.util.concurrent.ConcurrencyHelper;
import com.appdynamics.common.util.exception.PermanentException;
import com.appdynamics.common.util.exception.TransientException;
import com.appdynamics.common.util.execution.Countable;
import com.appdynamics.common.util.execution.Operation;
import com.appdynamics.common.util.execution.Retriable;
import com.appdynamics.common.util.execution.RetryConfiguration;
import com.appdynamics.common.util.item.Item;
import com.google.common.base.Throwables;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RetryWrapper<ID>
implements Item<ID> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryWrapper.class);
    static final String BEFORE_RESEND_MSG = "A retry attempt has been requested and it will be made after pausing for [%d] milliseconds";
    static final String NO_MORE_RESEND_MSG = "Further resend attempts will not be made after [%d] failed attempts";
    static final String TRANSIENT_ERR_MSG = "Error occurred while attempting to process data on [%s]. A retry attempt has been requested and it will be made after pausing for [%d] milliseconds";
    static final String PERMANENT_ERR_MSG_PART = "error occurred while attempting to send data on [%s]. Further resend attempts will not be made after [%d] failed attempts";
    final ID id;
    final RetryConfiguration retryConfiguration;

    public RetryWrapper(ID id, RetryConfiguration retryConfiguration) {
        this.id = id;
        this.retryConfiguration = retryConfiguration;
    }

    @Override
    public ID getId() {
        return this.id;
    }

    public RetryConfiguration getRetryConfiguration() {
        return this.retryConfiguration;
    }

    public <INPT extends Retriable> void invoke(INPT input, Operation<? super INPT> operation) {
        int maxAttempts = this.retryConfiguration.getTotalAttempts();
        float retryPauseMultiplier = this.retryConfiguration.getRetryPauseMultiplier();
        long maxRetryPauseMillis = this.retryConfiguration.getMaxRetryPauseMillis();
        long retryPauseMillis = this.retryConfiguration.getRetryPauseMillis();
        int attempt = 1;
        TransientException reattemptException = null;
        Object reattemptWarningMessage = null;
        do {
            if (operation instanceof Countable) {
                ((Countable)((Object)operation)).incrementCount();
            }
            if (attempt > 1) {
                log.warn(reattemptWarningMessage);
                ConcurrencyHelper.sleep(retryPauseMillis);
                if (retryPauseMillis < maxRetryPauseMillis && (retryPauseMillis = (long)((float)retryPauseMillis * retryPauseMultiplier)) > maxRetryPauseMillis) {
                    retryPauseMillis = maxRetryPauseMillis;
                }
                log.warn("Retry attempt [{}] by [{}]", (Object)attempt, this.id);
            }
            input.incAttempt();
            try {
                operation.process(input);
                boolean retry = input.done();
                if (!retry) {
                    return;
                }
                reattemptWarningMessage = String.format(BEFORE_RESEND_MSG, retryPauseMillis);
            }
            catch (TransientException te) {
                reattemptException = te;
                reattemptWarningMessage = String.format(TRANSIENT_ERR_MSG, this.id, retryPauseMillis) + "\n" + Throwables.getStackTraceAsString((Throwable)te);
            }
            catch (PermanentException pe) {
                log.error(String.format("Unrecoverable error occurred while attempting to send data on [%s]. Further resend attempts will not be made after [%d] failed attempts", this.id, attempt), (Throwable)pe);
                input.done(pe);
                throw pe;
            }
            catch (Throwable t) {
                log.error(String.format("Unrecoverable and unexpected error occurred while attempting to send data on [%s]. Further resend attempts will not be made after [%d] failed attempts", this.id, attempt), t);
                input.done(t);
                throw t;
            }
        } while (++attempt <= maxAttempts);
        String msg = String.format(NO_MORE_RESEND_MSG, Math.min(attempt, maxAttempts));
        PermanentException pe = reattemptException == null ? new PermanentException(msg) : new PermanentException(msg, reattemptException);
        input.done(pe);
        log.error(msg, (Throwable)pe);
    }
}

