/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.execution;

import com.appdynamics.common.util.configuration.ManualValidateable;
import com.appdynamics.common.util.configuration.ManualValidated;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraints.Min;
import lombok.Generated;

@ManualValidated
public class RetryConfiguration
implements ManualValidateable {
    @Min(value=1L)
    final @Min(value=1L) int totalAttempts;
    @Min(value=1L)
    final @Min(value=1L) long retryPauseMillis;
    @Min(value=1L)
    final @Min(value=1L) float retryPauseMultiplier;
    @Min(value=1L)
    final @Min(value=1L) long maxRetryPauseMillis;

    public RetryConfiguration() {
        this.totalAttempts = 1;
        this.retryPauseMillis = 1L;
        this.retryPauseMultiplier = 1.0f;
        this.maxRetryPauseMillis = 1L;
    }

    @JsonCreator
    public RetryConfiguration(@JsonProperty(value="totalAttempts") int totalAttempts, @JsonProperty(value="retryPauseMillis") long retryPauseMillis, @JsonProperty(value="retryPauseMultiplier") float retryPauseMultiplier, @JsonProperty(value="maxRetryPauseMillis") long maxRetryPauseMillis) {
        this.totalAttempts = totalAttempts;
        this.retryPauseMillis = retryPauseMillis;
        this.retryPauseMultiplier = retryPauseMultiplier;
        this.maxRetryPauseMillis = maxRetryPauseMillis;
    }

    @Override
    public boolean validate(ConstraintValidatorContext context) {
        if (this.maxRetryPauseMillis >= this.retryPauseMillis) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(String.format("must be greater than or equal to retryPauseMillis: [%s]", this.retryPauseMillis)).addPropertyNode("maxRetryPauseMillis").addConstraintViolation();
        return false;
    }

    @Generated
    public int getTotalAttempts() {
        return this.totalAttempts;
    }

    @Generated
    public long getRetryPauseMillis() {
        return this.retryPauseMillis;
    }

    @Generated
    public float getRetryPauseMultiplier() {
        return this.retryPauseMultiplier;
    }

    @Generated
    public long getMaxRetryPauseMillis() {
        return this.maxRetryPauseMillis;
    }
}

