/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.exception;

import com.appdynamics.common.util.exception.ThresholdCircuitBreaker;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ResettableCircuitBreaker
extends ThresholdCircuitBreaker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResettableCircuitBreaker.class);
    private final long downTime;
    private final long metricLifeTime;
    private long lastMetricCollectionTime;
    private long lastDownTime;
    private boolean isDown;

    ResettableCircuitBreaker(long downTime, long metricLifeTime, long minErrorCount, double maxErrorRatio, long maxErrorCount) {
        super(minErrorCount, maxErrorRatio, maxErrorCount);
        Preconditions.checkArgument((downTime > 0L ? 1 : 0) != 0, (Object)"downTime must be greater than 0");
        Preconditions.checkArgument((metricLifeTime > 0L ? 1 : 0) != 0, (Object)"metricLifeTime must be greater than 0");
        this.downTime = downTime;
        this.metricLifeTime = metricLifeTime;
        this.lastMetricCollectionTime = System.currentTimeMillis();
        this.isDown = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isCircuitDown(long success, long error) {
        long now = System.currentTimeMillis();
        if (now - this.lastMetricCollectionTime >= this.metricLifeTime) {
            this.resetCounts();
        }
        if (this.isDown) {
            if (now - this.lastDownTime < this.downTime) return true;
            log.info("Circuit breaker down time has elapsed and the circuit breaker is now back up");
            this.resetCounts();
            this.isDown = false;
            return false;
        } else {
            if (!super.isCircuitDown(success, error)) return false;
            log.warn("Circuit breaker has gone down as its error threshold was exceeded: success count [{}] error count [{}]", (Object)success, (Object)error);
            this.isDown = true;
            this.lastDownTime = System.currentTimeMillis();
            return true;
        }
    }

    @Override
    public void resetCounts() {
        this.lastMetricCollectionTime = System.currentTimeMillis();
        super.resetCounts();
    }
}

