/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.exception;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.util.LinkedList;
import org.slf4j.helpers.MessageFormatter;

public abstract class Exceptions {
    private static final Joiner MESSAGE_JOINER = Joiner.on((String)"\nCaused/related: ").skipNulls();

    private Exceptions() {
    }

    public static RuntimeException rethrowAsRuntimeException(InterruptedException e) {
        throw Exceptions.rethrowAsRuntimeException(null, e);
    }

    public static RuntimeException rethrowAsRuntimeException(String optionalMessage, InterruptedException e) {
        Thread.currentThread().interrupt();
        if (optionalMessage != null) {
            throw new RuntimeException(optionalMessage, e);
        }
        throw new RuntimeException(e);
    }

    public static RuntimeException addSuppressedMsgAndPropagate(Exception e, String format, Object ... args) {
        RuntimeException runtime = new RuntimeException(MessageFormatter.arrayFormat((String)format, (Object[])args).getMessage());
        e.addSuppressed(runtime);
        return Throwables.propagate((Throwable)e);
    }

    public static String collectMessages(Throwable t) {
        LinkedList<String> messages = new LinkedList<String>();
        for (Throwable throwable : Throwables.getCausalChain((Throwable)t)) {
            String s = throwable.getMessage();
            if (!Strings.isNullOrEmpty((String)s)) {
                messages.add(s);
            }
            Exceptions.collectSuppressedMessages(throwable, messages);
        }
        return MESSAGE_JOINER.join(messages);
    }

    private static void collectSuppressedMessages(Throwable t, LinkedList<String> messages) {
        Throwable[] allSuppressed;
        for (Throwable suppressed : allSuppressed = t.getSuppressed()) {
            String s = suppressed.getMessage();
            if (Strings.isNullOrEmpty((String)s)) continue;
            messages.add(s);
        }
    }
}

