/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.exception;

import com.appdynamics.common.util.exception.PermanentException;
import com.appdynamics.common.util.exception.TransientException;
import com.google.common.base.Throwables;
import lombok.Generated;
import org.slf4j.Logger;

public final class ExceptionHandler {
    final Logger log;
    final String interruptedLogMessage;
    final String transientLogMessage;
    final String permanentLogMessage;
    final String unknownLogMessage;
    final boolean rethrowUnknown;

    public ExceptionHandler(Logger log, String interruptedLogMessage, String transientLogMessage, String permanentLogMessage, String unknownLogMessage, boolean rethrowUnknown) {
        this.log = log;
        this.interruptedLogMessage = interruptedLogMessage;
        this.transientLogMessage = transientLogMessage;
        this.permanentLogMessage = permanentLogMessage;
        this.unknownLogMessage = (rethrowUnknown ? "" : "(Suppressed) ") + unknownLogMessage;
        this.rethrowUnknown = rethrowUnknown;
    }

    public ExceptionHandler(Logger log) {
        this(log, "Thread was interrupted", "Transient error", "Permanent error", "Unexpected error", true);
    }

    public void handle(Throwable throwable) throws InterruptedException {
        if (throwable instanceof InterruptedException) {
            this.log.debug(this.interruptedLogMessage, throwable);
            Thread.currentThread().interrupt();
            throw (InterruptedException)throwable;
        }
        if (throwable instanceof TransientException) {
            this.log.warn(this.transientLogMessage, throwable);
        } else {
            if (throwable instanceof PermanentException || throwable instanceof Error) {
                this.log.error(this.permanentLogMessage, throwable);
                throw Throwables.propagate((Throwable)throwable);
            }
            this.log.error(this.unknownLogMessage, throwable);
            if (this.rethrowUnknown) {
                throw Throwables.propagate((Throwable)throwable);
            }
        }
    }

    @Generated
    public Logger getLog() {
        return this.log;
    }

    @Generated
    public String getInterruptedLogMessage() {
        return this.interruptedLogMessage;
    }

    @Generated
    public String getTransientLogMessage() {
        return this.transientLogMessage;
    }

    @Generated
    public String getPermanentLogMessage() {
        return this.permanentLogMessage;
    }

    @Generated
    public String getUnknownLogMessage() {
        return this.unknownLogMessage;
    }

    @Generated
    public boolean isRethrowUnknown() {
        return this.rethrowUnknown;
    }
}

