/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.configuration;

import com.appdynamics.common.util.configuration.ErrorMessageBuilder;
import jakarta.validation.ConstraintViolation;
import java.util.Set;

public class SimpleErrorMessageBuilder<T>
implements ErrorMessageBuilder<T> {
    @Override
    public String buildErrorMessage(T configuration, Set<ConstraintViolation<T>> errors) {
        if (configuration == null || errors == null || errors.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Error occurred while validating instance of [").append(configuration.getClass().getName()).append("].").append(" Found [").append(errors.size()).append("] errors.\n");
        for (ConstraintViolation<T> error : errors) {
            sb.append("Error found at:\n").append(error.getPropertyPath()).append("\n").append("Reason:\n").append(error.getMessage()).append("\n");
        }
        return sb.toString();
    }
}

