/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.configuration;

import com.appdynamics.common.util.configuration.ConfigurationException;
import com.google.common.base.MoreObjects;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class Parameters {
    private Parameters() {
    }

    public static String toStringOrNull(Object obj) {
        return obj == null ? null : (obj instanceof String ? (String)obj : obj.toString());
    }

    public static String toStringOrBlank(Object obj) {
        return obj == null ? "" : (obj instanceof String ? (String)obj : obj.toString());
    }

    public static String defaultIfBlank(String input, String defaultValue, boolean trim) {
        if (input == null || input.length() == 0) {
            return defaultValue;
        }
        if (!trim) {
            return input;
        }
        String s = input.trim();
        return s.length() == 0 ? defaultValue : s;
    }

    public static String defaultIfBlank(String input, String defaultValue) {
        return Parameters.defaultIfBlank(input, defaultValue, false);
    }

    public static String asMandatoryString(Object param, String exceptionMessage, boolean trim) {
        String paramStr = Parameters.defaultIfBlank(Parameters.toStringOrNull(param), null, trim);
        if (paramStr == null) {
            throw new ConfigurationException(exceptionMessage);
        }
        return paramStr;
    }

    public static String asMandatoryString(Object param, String exceptionMessage) {
        return Parameters.asMandatoryString(param, exceptionMessage, false);
    }

    public static String asString(Object param, String defaultValue) {
        return Parameters.defaultIfBlank(Parameters.toStringOrNull(param), defaultValue);
    }

    public static <T> T firstNonNull(T a, T b, T c) {
        T x = a == null ? b : a;
        return (T)MoreObjects.firstNonNull(x, c);
    }

    public static Map<String, Object> consolidate(Map<String, Object> level1, Map<String, Object> level2) {
        LinkedHashMap<String, Object> map = null;
        if (level1 != null) {
            map = new LinkedHashMap<String, Object>(level1);
        }
        if (map == null) {
            if (level2 == null) {
                throw new IllegalArgumentException("Fields/properties must be specified");
            }
            map = new LinkedHashMap(8);
        }
        if (level2 != null) {
            map.putAll(level2);
        }
        return map;
    }
}

