/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.configuration;

import com.appdynamics.common.util.configuration.ErrorMessageBuilder;
import jakarta.validation.ConstraintViolation;
import java.util.Set;

class DefaultErrorMessageBuilder<T>
implements ErrorMessageBuilder<T> {
    DefaultErrorMessageBuilder() {
    }

    @Override
    public String buildErrorMessage(T configuration, Set<ConstraintViolation<T>> errors) {
        StringBuilder sb = new StringBuilder();
        for (ConstraintViolation<T> error : errors) {
            sb.append(error.getMessage());
            String propertyPath = error.getPropertyPath().toString();
            if (!propertyPath.isEmpty()) {
                sb.append(". Property [").append(propertyPath).append(']');
            }
            sb.append(". Found invalid value [").append(error.getInvalidValue()).append("]").append("\n");
        }
        return sb.toString();
    }
}

