/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.concurrent;

import com.google.common.base.Function;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class ParallelUtil {
    private ParallelUtil() {
    }

    public static <T> void forLoop(int numThreads, int timeoutInSeconds, Iterable<T> iterable, final Function<T, Void> loopFunction) throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        LinkedList<Future<Void>> futures = new LinkedList<Future<Void>>();
        Iterator<T> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            T item;
            final T loopItem = item = iterator.next();
            futures.add(executor.submit(new Callable<Void>(){

                @Override
                public Void call() {
                    return (Void)loopFunction.apply(loopItem);
                }
            }));
        }
        while (!futures.isEmpty()) {
            Future future = (Future)futures.remove();
            try {
                future.get(timeoutInSeconds, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                while (!futures.isEmpty()) {
                    ((Future)futures.remove()).cancel(false);
                }
                throw e;
            }
        }
    }
}

